/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.CfgUtils;
import org.sonar.python.cfg.fixpoint.DefinedVariablesAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3827")
public class ReferencedBeforeAssignmentCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            ArrayList ignoredSymbols = new ArrayList();
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.hasDescendant((Tree)functionDef, tree -> tree.is(new Tree.Kind[]{Tree.Kind.TRY_STMT}))) {
                return;
            }
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            DefinedVariablesAnalysis analysis = DefinedVariablesAnalysis.analyze((ControlFlowGraph)cfg, (Set)functionDef.localVariables());
            Set unreachableBlocks = CfgUtils.unreachableBlocks((ControlFlowGraph)cfg);
            cfg.blocks().forEach(block -> ReferencedBeforeAssignmentCheck.checkCfgBlock(block, ctx, analysis.getDefinedVariables(block), unreachableBlocks, analysis, ignoredSymbols));
        });
    }

    private static void checkCfgBlock(CfgBlock cfgBlock, SubscriptionContext ctx, DefinedVariablesAnalysis.DefinedVariables definedVariables, Set<CfgBlock> unreachableBlocks, DefinedVariablesAnalysis analysis, List<Symbol> ignoredSymbols) {
        HashMap currentState = new HashMap(definedVariables.getIn());
        for (Tree element : cfgBlock.elements()) {
            definedVariables.getSymbolReadWrites(element).forEach((symbol, symbolReadWrite) -> {
                if (symbolReadWrite.isWrite()) {
                    currentState.put(symbol, DefinedVariablesAnalysis.VariableDefinition.DEFINED);
                }
                DefinedVariablesAnalysis.VariableDefinition varDef = currentState.getOrDefault(symbol, DefinedVariablesAnalysis.VariableDefinition.DEFINED);
                if (symbolReadWrite.isRead() && ReferencedBeforeAssignmentCheck.isUndefined(varDef) && !ReferencedBeforeAssignmentCheck.isSymbolUsedInUnreachableBlocks(analysis, unreachableBlocks, symbol) && !ReferencedBeforeAssignmentCheck.isParameter(element) && !ignoredSymbols.contains(symbol)) {
                    ignoredSymbols.add((Symbol)symbol);
                    Usage suspectUsage = (Usage)symbolReadWrite.usages().get(0);
                    PythonCheck.PreciseIssue issue = ctx.addIssue(suspectUsage.tree(), symbol.name() + " is used before it is defined. Move the definition before.");
                    symbol.usages().stream().filter(u -> !u.equals(suspectUsage)).forEach(us -> issue.secondary(us.tree(), null));
                }
            });
        }
    }

    private static boolean isParameter(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.PARAMETER});
    }

    private static boolean isSymbolUsedInUnreachableBlocks(DefinedVariablesAnalysis analysis, Set<CfgBlock> unreachableBlocks, Symbol symbol) {
        return unreachableBlocks.stream().anyMatch(b -> analysis.getDefinedVariables(b).isSymbolUsedInBlock(symbol));
    }

    private static boolean isUndefined(DefinedVariablesAnalysis.VariableDefinition varDef) {
        return varDef == DefinedVariablesAnalysis.VariableDefinition.UNDEFINED;
    }
}

