/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.PythonCfgBranchingBlock;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3516")
public class InvariantReturnCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Refactor this method to not always return the same value.";
    private static final Tree.Kind[] BINARY_EXPRESSION_KINDS = new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLICATION, Tree.Kind.DIVISION, Tree.Kind.FLOOR_DIVISION, Tree.Kind.MODULO, Tree.Kind.MATRIX_MULTIPLICATION, Tree.Kind.SHIFT_EXPR, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR, Tree.Kind.BITWISE_XOR, Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.COMPARISON, Tree.Kind.POWER};
    private static final Tree.Kind[] UNARY_EXPRESSION_KINDS = new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.NOT};

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg != null) {
                List<LatestExecutedBlock> latestExecutedBlocks = InvariantReturnCheck.collectLatestExecutedBlocks(cfg);
                boolean allBlocksHaveReturnStatement = latestExecutedBlocks.stream().allMatch(rec$ -> ((LatestExecutedBlock)rec$).hasReturnStatement());
                if (latestExecutedBlocks.size() <= 1 || !allBlocksHaveReturnStatement) {
                    return;
                }
                boolean noEmptyReturn = latestExecutedBlocks.stream().noneMatch(rec$ -> ((LatestExecutedBlock)rec$).returnNone());
                if (noEmptyReturn && InvariantReturnCheck.returnExpressionsHaveTheSameValue(latestExecutedBlocks)) {
                    PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)functionDef.name(), MESSAGE);
                    latestExecutedBlocks.forEach(block -> issue.secondary((Tree)((LatestExecutedBlock)block).returnStatement, "returned value"));
                }
            }
        });
    }

    private static List<LatestExecutedBlock> collectLatestExecutedBlocks(ControlFlowGraph cfg) {
        ArrayList<LatestExecutedBlock> collectedBlocks = new ArrayList<LatestExecutedBlock>();
        for (CfgBlock predecessor : cfg.end().predecessors()) {
            if (predecessor instanceof PythonCfgBranchingBlock) {
                InvariantReturnCheck.collectBranchingBlock(collectedBlocks, (PythonCfgBranchingBlock)predecessor);
                continue;
            }
            if (InvariantReturnCheck.endsWithElementKind(predecessor, Tree.Kind.RAISE_STMT)) continue;
            collectedBlocks.add(new LatestExecutedBlock(predecessor));
        }
        return collectedBlocks;
    }

    private static void collectBranchingBlock(List<LatestExecutedBlock> collectedBlocks, PythonCfgBranchingBlock branchingBlock) {
        Tree branchingTree = branchingBlock.branchingTree();
        if (branchingTree.is(new Tree.Kind[]{Tree.Kind.TRY_STMT})) {
            TryStatement tryStatement = (TryStatement)branchingTree;
            if (!TreeUtils.hasDescendant((Tree)tryStatement.body(), t -> t.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT}))) {
                collectedBlocks.add(new LatestExecutedBlock((CfgBlock)branchingBlock));
            }
        } else if (branchingTree.is(new Tree.Kind[]{Tree.Kind.IF_STMT})) {
            collectedBlocks.add(new LatestExecutedBlock((CfgBlock)branchingBlock));
        } else {
            InvariantReturnCheck.collectBlocksHavingReturnBeforeExceptOrFinallyBlock(collectedBlocks, branchingBlock);
        }
    }

    private static void collectBlocksHavingReturnBeforeExceptOrFinallyBlock(List<LatestExecutedBlock> collectedBlocks, PythonCfgBranchingBlock branchingBlock) {
        if (branchingBlock.branchingTree().is(new Tree.Kind[]{Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.FINALLY_CLAUSE})) {
            for (CfgBlock predecessor : branchingBlock.predecessors()) {
                if (predecessor instanceof PythonCfgBranchingBlock) {
                    InvariantReturnCheck.collectBlocksHavingReturnBeforeExceptOrFinallyBlock(collectedBlocks, (PythonCfgBranchingBlock)predecessor);
                    continue;
                }
                if (!InvariantReturnCheck.endsWithElementKind(predecessor, Tree.Kind.RETURN_STMT)) continue;
                collectedBlocks.add(new LatestExecutedBlock(predecessor));
            }
        }
    }

    private static boolean returnExpressionsHaveTheSameValue(List<LatestExecutedBlock> latestExecutedBlocks) {
        for (int i = 1; i < latestExecutedBlocks.size(); ++i) {
            if (InvariantReturnCheck.haveTheSameValue(latestExecutedBlocks.get(i - 1), latestExecutedBlocks.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean haveTheSameValue(LatestExecutedBlock left, LatestExecutedBlock right) {
        return InvariantReturnCheck.haveTheSameValue(left, left.returnExpressions(), right, right.returnExpressions());
    }

    private static boolean haveTheSameValue(LatestExecutedBlock leftBlock, List<? extends Tree> left, LatestExecutedBlock rightBlock, List<? extends Tree> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (InvariantReturnCheck.haveTheSameValue(leftBlock, left.get(i), rightBlock, right.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean haveTheSameValue(LatestExecutedBlock leftBlock, Tree left, LatestExecutedBlock rightBlock, Tree right) {
        if (left.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            return InvariantReturnCheck.haveTheSameValue(leftBlock, (Tree)((ParenthesizedExpression)left).expression(), rightBlock, right);
        }
        if (right.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            return InvariantReturnCheck.haveTheSameValue(leftBlock, left, rightBlock, (Tree)((ParenthesizedExpression)right).expression());
        }
        if (left.getKind() != right.getKind()) {
            return false;
        }
        if (left.is(UNARY_EXPRESSION_KINDS)) {
            return InvariantReturnCheck.unaryExpressionsHaveTheSameValue(leftBlock, (UnaryExpression)left, rightBlock, (UnaryExpression)right);
        }
        if (left.is(BINARY_EXPRESSION_KINDS)) {
            return InvariantReturnCheck.binaryExpressionsHaveTheSameValue(leftBlock, (BinaryExpression)left, rightBlock, (BinaryExpression)right);
        }
        if (left.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return InvariantReturnCheck.haveTheSameValue(leftBlock, left.children(), rightBlock, right.children());
        }
        if (left.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_ELEMENT})) {
            return left.firstToken().value().equals(right.firstToken().value());
        }
        if (left.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return InvariantReturnCheck.identifierHaveTheSameValue(leftBlock, (Name)left, rightBlock, (Name)right);
        }
        return false;
    }

    private static boolean unaryExpressionsHaveTheSameValue(LatestExecutedBlock leftBlock, UnaryExpression left, LatestExecutedBlock rightBlock, UnaryExpression right) {
        return InvariantReturnCheck.haveTheSameValue(leftBlock, (Tree)left.expression(), rightBlock, (Tree)right.expression());
    }

    private static boolean binaryExpressionsHaveTheSameValue(LatestExecutedBlock leftBlock, BinaryExpression left, LatestExecutedBlock rightBlock, BinaryExpression right) {
        return InvariantReturnCheck.haveTheSameValue(leftBlock, (Tree)left.leftOperand(), rightBlock, (Tree)right.leftOperand()) && InvariantReturnCheck.haveTheSameValue(leftBlock, (Tree)left.rightOperand(), rightBlock, (Tree)right.rightOperand());
    }

    private static boolean identifierHaveTheSameValue(LatestExecutedBlock leftBlock, Name left, LatestExecutedBlock rightBlock, Name right) {
        if (left.name().equals("True") || left.name().equals("False")) {
            return right.name().equals(left.name());
        }
        Symbol leftSymbol = left.symbol();
        Symbol rightSymbol = right.symbol();
        if (leftSymbol == null || !leftSymbol.equals(rightSymbol)) {
            return false;
        }
        Tree leftBinding = InvariantReturnCheck.findUniquePreviousBinding(leftBlock, leftSymbol);
        Tree rightBinding = InvariantReturnCheck.findUniquePreviousBinding(rightBlock, rightSymbol);
        return leftBinding != null && leftBinding == rightBinding;
    }

    private static Tree findUniquePreviousBinding(LatestExecutedBlock context, Symbol identifier) {
        HashSet<CfgBlock> pushedBlocks = new HashSet<CfgBlock>();
        ArrayDeque<CfgBlock> blockToVisit = new ArrayDeque<CfgBlock>();
        blockToVisit.push(context.block);
        pushedBlocks.add(context.block);
        HashSet<Tree> bindings = new HashSet<Tree>();
        while (!blockToVisit.isEmpty() && bindings.size() < 2) {
            CfgBlock block = (CfgBlock)blockToVisit.pop();
            Tree binding = InvariantReturnCheck.findLastBinding(block.elements(), identifier);
            if (binding != null) {
                bindings.add(binding);
                continue;
            }
            for (CfgBlock predecessor : block.predecessors()) {
                if (!pushedBlocks.add(predecessor)) continue;
                blockToVisit.push(predecessor);
            }
        }
        return bindings.size() == 1 ? (Tree)bindings.iterator().next() : null;
    }

    @Nullable
    private static Tree findLastBinding(List<Tree> elements, Symbol identifier) {
        for (int i = elements.size() - 1; i >= 0; --i) {
            Tree binding = InvariantReturnCheck.findLastBinding(elements.get(i), identifier);
            if (binding == null) continue;
            return binding;
        }
        return null;
    }

    @Nullable
    private static Tree findLastBinding(Tree context, Symbol identifier) {
        Name name;
        if (context.is(new Tree.Kind[]{Tree.Kind.NAME}) && identifier.equals((name = (Name)context).symbol()) && InvariantReturnCheck.couldBeModified(name)) {
            return name;
        }
        return InvariantReturnCheck.findLastBinding(context.children(), identifier);
    }

    private static boolean couldBeModified(Name name) {
        Name child = name;
        Tree parent = child.parent();
        while (parent.is(new Tree.Kind[]{Tree.Kind.STATEMENT_LIST, Tree.Kind.PARENTHESIZED, Tree.Kind.QUALIFIED_EXPR, Tree.Kind.SUBSCRIPTION, Tree.Kind.TUPLE})) {
            child = parent;
            parent = child.parent();
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT, Tree.Kind.CONDITIONAL_EXPR, Tree.Kind.ELSE_CLAUSE, Tree.Kind.WHILE_STMT, Tree.Kind.EXPRESSION_STMT, Tree.Kind.IF_STMT}) || parent.is(UNARY_EXPRESSION_KINDS) || parent.is(BINARY_EXPRESSION_KINDS)) {
            return false;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
            return ((AssignmentStatement)parent).lhsExpressions() == child;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.FOR_STMT})) {
            return ((ForStatement)parent).expressions().contains(child);
        }
        return true;
    }

    private static boolean endsWithElementKind(CfgBlock block, Tree.Kind kind) {
        return InvariantReturnCheck.lastElement(block, kind) != null;
    }

    @Nullable
    private static Tree lastElement(CfgBlock block, Tree.Kind kind) {
        List elements = block.elements();
        int last = elements.size() - 1;
        return !elements.isEmpty() && ((Tree)elements.get(last)).is(new Tree.Kind[]{kind}) ? (Tree)elements.get(last) : null;
    }

    private static class LatestExecutedBlock {
        private final CfgBlock block;
        @Nullable
        private final ReturnStatement returnStatement;

        private LatestExecutedBlock(CfgBlock block) {
            this.block = block;
            this.returnStatement = (ReturnStatement)InvariantReturnCheck.lastElement(block, Tree.Kind.RETURN_STMT);
        }

        private boolean hasReturnStatement() {
            return this.returnStatement != null;
        }

        private List<Expression> returnExpressions() {
            return this.returnStatement.expressions();
        }

        private boolean returnNone() {
            List expressions = this.returnStatement.expressions();
            return expressions.isEmpty() || expressions.size() == 1 && ((Expression)expressions.get(0)).is(new Tree.Kind[]{Tree.Kind.NONE});
        }
    }
}

