/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;

public abstract class SillyEquality
extends PythonSubscriptionCheck {
    private static final HashSet<String> CONSIDERED_OPERATORS = new HashSet<String>(Arrays.asList("==", "!="));
    protected static final HashMap<String, String> BUILTINS_TYPE_CATEGORY = new HashMap();
    private static final String NUMBER = "number";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
            String operator = binaryExpression.operator().value();
            if (!CONSIDERED_OPERATORS.contains(operator)) {
                return;
            }
            this.checkIncompatibleTypes((SubscriptionContext)ctx, binaryExpression);
        });
    }

    private void checkIncompatibleTypes(SubscriptionContext ctx, BinaryExpression binaryExpression) {
        InferredType rightType;
        Expression left = binaryExpression.leftOperand();
        Expression right = binaryExpression.rightOperand();
        InferredType leftType = left.type();
        if (this.areIdentityComparableOrNone(leftType, rightType = right.type())) {
            return;
        }
        String leftCategory = this.builtinTypeCategory(leftType);
        String rightCategory = this.builtinTypeCategory(rightType);
        boolean leftCanImplementEqOrNe = this.canImplementEqOrNe(left);
        boolean rightCanImplementEqOrNe = this.canImplementEqOrNe(right);
        if (leftCategory != null && leftCategory.equals(rightCategory)) {
            return;
        }
        if (!leftCanImplementEqOrNe && !rightCanImplementEqOrNe || leftCategory != null && rightCategory != null || leftCategory != null && !rightCanImplementEqOrNe || rightCategory != null && !leftCanImplementEqOrNe) {
            this.raiseIssue(ctx, binaryExpression, binaryExpression.operator().value());
        }
    }

    private void raiseIssue(SubscriptionContext ctx, BinaryExpression binaryExpression, String operator) {
        String result = operator.equals("==") ? "False" : "True";
        ctx.addIssue(binaryExpression.operator(), this.message(result));
    }

    abstract boolean areIdentityComparableOrNone(InferredType var1, InferredType var2);

    abstract boolean canImplementEqOrNe(Expression var1);

    @CheckForNull
    abstract String builtinTypeCategory(InferredType var1);

    abstract String message(String var1);

    static {
        BUILTINS_TYPE_CATEGORY.put("str", "str");
        BUILTINS_TYPE_CATEGORY.put("int", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("float", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("complex", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("bool", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("list", "list");
        BUILTINS_TYPE_CATEGORY.put("set", "set");
        BUILTINS_TYPE_CATEGORY.put("frozenset", "set");
        BUILTINS_TYPE_CATEGORY.put("dict", "dict");
        BUILTINS_TYPE_CATEGORY.put("tuple", "tuple");
    }
}

