/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

@Rule(key="S5361")
public class StringReplaceCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Replace this \"re.sub()\" call by a \"str.replace()\" function call.";
    private static final String SECONDARY_MESSAGE = "Expression without regular expression features.";

    @Override
    protected Map<String, Integer> lookedUpFunctions() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("re.sub", 4);
        return result;
    }

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression callExpression) {
        RegexTree regex = regexParseResult.getResult();
        if (!regexParseResult.hasSyntaxErrors() && StringReplaceCheck.isPlainString(regex)) {
            this.regexContext.addIssue((Tree)callExpression.callee(), MESSAGE).secondary(PythonRegexIssueLocation.preciseLocation((RegexSyntaxElement)regex, (String)SECONDARY_MESSAGE));
        }
    }

    private static boolean isPlainString(RegexTree regex) {
        return regex.is(new RegexTree.Kind[]{RegexTree.Kind.CHARACTER}) || regex.is(new RegexTree.Kind[]{RegexTree.Kind.SEQUENCE}) && !((SequenceTree)regex).getItems().isEmpty() && ((SequenceTree)regex).getItems().stream().allMatch(item -> item.is(new RegexTree.Kind[]{RegexTree.Kind.CHARACTER}));
    }
}

