/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public abstract class AbstractUnreadPrivateMembersCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        String memberPrefix = this.memberPrefix();
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> Optional.of(ctx.syntaxNode()).map(ClassDef.class::cast).filter(classDef -> classDef.decorators().isEmpty()).map(TreeUtils::getClassSymbolFromDef).map(ClassSymbol::declaredMembers).stream().flatMap(Collection::stream).filter(s -> s.name().startsWith(memberPrefix) && !s.name().endsWith("__") && this.equalsToKind((Symbol)s) && AbstractUnreadPrivateMembersCheck.isNeverRead(s)).filter(Predicate.not(this::isException)).forEach(symbol -> this.reportIssue((SubscriptionContext)ctx, (Symbol)symbol)));
    }

    protected boolean isException(Symbol symbol) {
        return false;
    }

    private boolean equalsToKind(Symbol symbol) {
        if (symbol.kind().equals((Object)Symbol.Kind.AMBIGUOUS)) {
            return ((AmbiguousSymbol)symbol).alternatives().stream().allMatch(s -> s.kind() == this.kind());
        }
        return symbol.kind() == this.kind();
    }

    private void reportIssue(SubscriptionContext ctx, Symbol symbol) {
        PythonCheck.PreciseIssue preciseIssue = null;
        for (int i = 0; i < symbol.usages().size(); ++i) {
            Usage usage = (Usage)symbol.usages().get(i);
            if (i == 0) {
                preciseIssue = ctx.addIssue(usage.tree(), this.message(symbol.name()));
                continue;
            }
            preciseIssue.secondary(usage.tree(), this.secondaryMessage());
        }
    }

    private static boolean isNeverRead(Symbol symbol) {
        return symbol.usages().stream().allMatch(Usage::isBindingUsage);
    }

    abstract String memberPrefix();

    abstract Symbol.Kind kind();

    abstract String message(String var1);

    abstract String secondaryMessage();
}

