/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.finders.VerboseRegexFinder;

@Rule(key="S6353")
public class VerboseRegexCheck
extends AbstractRegexCheck {
    private static final String ISSUE_MESSAGE_PATTERN = ".+syntax '(.+)' instead of.+";
    private static final Pattern issueMessagePattern = Pattern.compile(".+syntax '(.+)' instead of.+");
    public static final String QUICK_FIX_FORMAT = "Replace with \"%s\"";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        new VerboseRegexFinder(this::addIssue).visit(regexParseResult);
    }

    @Override
    public PythonCheck.PreciseIssue addIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        return Optional.ofNullable(super.addIssue(regexTree, message, cost, secondaries)).map(issue -> {
            Matcher matcher = issueMessagePattern.matcher(message);
            String quickFixReplacement = matcher.replaceFirst("$1");
            IssueLocation issueLocation = PythonRegexIssueLocation.preciseLocation((RegexSyntaxElement)regexTree, null);
            PythonTextEdit textEdit = new PythonTextEdit(quickFixReplacement, issueLocation.startLine(), issueLocation.startLineOffset(), issueLocation.endLine(), issueLocation.endLineOffset());
            issue.addQuickFix(PythonQuickFix.newQuickFix((String)String.format(QUICK_FIX_FORMAT, quickFixReplacement), (PythonTextEdit[])new PythonTextEdit[]{textEdit}));
            return issue;
        }).orElse(null);
    }
}

