/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5547")
public class RobustCipherAlgorithmCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a strong cipher algorithm.";
    private static final HashSet<String> sensitiveCalleeFqns = new HashSet();
    private static final Set<String> INSECURE_CIPHERS = Set.of("NULL", "RC2", "RC4", "DES", "3DES", "MD5", "SHA");
    public static final String SSL_SET_CIPHERS_FQN = "ssl.SSLContext.set_ciphers";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, subscriptionContext -> {
            CallExpression callExpr = (CallExpression)subscriptionContext.syntaxNode();
            Optional.ofNullable(callExpr).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter(fqn -> sensitiveCalleeFqns.contains(fqn) || SSL_SET_CIPHERS_FQN.equals(fqn) && RobustCipherAlgorithmCheck.hasArgumentWithSensitiveAlgorithm(callExpr)).ifPresent(fqn -> subscriptionContext.addIssue((Tree)callExpr.callee(), MESSAGE));
        });
    }

    private static boolean hasArgumentWithSensitiveAlgorithm(CallExpression callExpression) {
        return Optional.of(callExpression.arguments()).filter(list -> list.size() == 1).map(list -> (Argument)list.get(0)).flatMap(TreeUtils.toOptionalInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression).map(RobustCipherAlgorithmCheck::unpackArgument).filter(RobustCipherAlgorithmCheck::containsInsecureCipher).isPresent();
    }

    @CheckForNull
    private static String unpackArgument(@Nullable Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return ((StringLiteralImpl)expression).trimmedQuotesValue();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return RobustCipherAlgorithmCheck.unpackArgument(Expressions.singleAssignedValue((Name)expression));
        }
        return null;
    }

    private static boolean containsInsecureCipher(String ciphers) {
        return Stream.of(ciphers).flatMap(str -> Arrays.stream(str.split(":"))).flatMap(str -> Arrays.stream(str.split("-"))).anyMatch(INSECURE_CIPHERS::contains);
    }

    static {
        for (String libraryName : Arrays.asList("Cryptodome", "Crypto")) {
            for (String vulnerableMethodName : Arrays.asList("DES", "DES3", "ARC2", "ARC4", "Blowfish")) {
                sensitiveCalleeFqns.add(String.format("%s.Cipher.%s.new", libraryName, vulnerableMethodName));
            }
        }
        for (String methodName : Arrays.asList("TripleDES", "Blowfish", "ARC4", "IDEA")) {
            sensitiveCalleeFqns.add(String.format("cryptography.hazmat.primitives.ciphers.algorithms.%s", methodName));
        }
        sensitiveCalleeFqns.add("pyDes.des");
        sensitiveCalleeFqns.add("pyDes.triple_des");
    }
}

