/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3923")
public class AllBranchesAreIdenticalCheck
extends PythonSubscriptionCheck {
    private static final String IF_STATEMENT_MESSAGE = "Remove this if statement or edit its code blocks so that they're not all the same.";
    private static final String CONDITIONAL_MESSAGE = "This conditional expression returns the same value whether the condition is \"true\" or \"false\".";
    private static final List<ConditionalExpression> ignoreList = new ArrayList<ConditionalExpression>();
    public static final String SECONDARY_MESSAGE = "Duplicated statements.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> ignoreList.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> AllBranchesAreIdenticalCheck.handleIfStatement((IfStatement)ctx.syntaxNode(), ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> AllBranchesAreIdenticalCheck.handleConditionalExpression((ConditionalExpression)ctx.syntaxNode(), ctx));
    }

    private static void handleIfStatement(IfStatement ifStmt, SubscriptionContext ctx) {
        ElseClause elseBranch = ifStmt.elseBranch();
        if (elseBranch == null) {
            return;
        }
        StatementList body = ifStmt.body();
        for (IfStatement elifBranch : ifStmt.elifBranches()) {
            StatementList elifBody = elifBranch.body();
            if (CheckUtils.areEquivalent((Tree)body, (Tree)elifBody)) continue;
            return;
        }
        if (!CheckUtils.areEquivalent((Tree)body, (Tree)elseBranch.body())) {
            return;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue(ifStmt.keyword(), IF_STATEMENT_MESSAGE);
        issue.secondary(AllBranchesAreIdenticalCheck.secondaryIssueLocation(ifStmt.body()));
        ifStmt.elifBranches().forEach(e -> issue.secondary(AllBranchesAreIdenticalCheck.secondaryIssueLocation(e.body())));
        issue.secondary(AllBranchesAreIdenticalCheck.secondaryIssueLocation(elseBranch.body()));
        if (!AllBranchesAreIdenticalCheck.hasSideEffect(ifStmt)) {
            issue.addQuickFix(AllBranchesAreIdenticalCheck.computeQuickFixForIfStatement(ifStmt, elseBranch));
        }
    }

    private static IssueLocation secondaryIssueLocation(StatementList body) {
        List tokens = TreeUtils.nonWhitespaceTokens((Tree)body);
        return IssueLocation.preciseLocation((Token)((Token)tokens.get(0)), (Token)((Token)tokens.get(tokens.size() - 1)), (String)SECONDARY_MESSAGE);
    }

    private static void handleConditionalExpression(ConditionalExpression conditionalExpression, SubscriptionContext ctx) {
        if (ignoreList.contains(conditionalExpression)) {
            return;
        }
        if (AllBranchesAreIdenticalCheck.areIdentical(conditionalExpression.trueExpression(), conditionalExpression.falseExpression())) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(conditionalExpression.ifKeyword(), CONDITIONAL_MESSAGE);
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.trueExpression());
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.falseExpression());
            issue.addQuickFix(AllBranchesAreIdenticalCheck.computeQuickFixForConditional(conditionalExpression));
        }
    }

    private static void addSecondaryLocations(PythonCheck.PreciseIssue issue, Expression expression) {
        Expression unwrappedExpression = Expressions.removeParentheses(expression);
        if (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)unwrappedExpression;
            ignoreList.add(conditionalExpression);
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.trueExpression());
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.falseExpression());
        } else {
            issue.secondary((Tree)unwrappedExpression, SECONDARY_MESSAGE);
        }
    }

    private static boolean areIdentical(Expression trueExpression, Expression falseExpression) {
        Expression unwrappedTrueExpression = AllBranchesAreIdenticalCheck.unwrapIdenticalExpressions(trueExpression);
        Expression unwrappedFalseExpression = AllBranchesAreIdenticalCheck.unwrapIdenticalExpressions(falseExpression);
        return CheckUtils.areEquivalent((Tree)unwrappedTrueExpression, (Tree)unwrappedFalseExpression);
    }

    private static Expression unwrapIdenticalExpressions(Expression expression) {
        boolean identicalExpressions;
        Expression unwrappedExpression = Expressions.removeParentheses(expression);
        if (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR}) && (identicalExpressions = AllBranchesAreIdenticalCheck.areIdentical(((ConditionalExpression)unwrappedExpression).trueExpression(), ((ConditionalExpression)unwrappedExpression).falseExpression()))) {
            while (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
                unwrappedExpression = Expressions.removeParentheses(((ConditionalExpression)unwrappedExpression).trueExpression());
            }
        }
        return unwrappedExpression;
    }

    private static PythonQuickFix computeQuickFixForConditional(ConditionalExpression conditional) {
        return PythonQuickFix.newQuickFix((String)"Remove the if statement").addTextEdit(new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)conditional.firstToken(), (Tree)AllBranchesAreIdenticalCheck.lastFalseExpression(conditional))}).build();
    }

    private static Tree lastFalseExpression(ConditionalExpression conditional) {
        Expression falseExpression = conditional.falseExpression();
        if (falseExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
            return AllBranchesAreIdenticalCheck.lastFalseExpression((ConditionalExpression)conditional.falseExpression());
        }
        return falseExpression;
    }

    private static PythonQuickFix computeQuickFixForIfStatement(IfStatement ifStatement, ElseClause elseClause) {
        PythonQuickFix.Builder builder = PythonQuickFix.newQuickFix((String)"Remove the if statement");
        builder.addTextEdit(new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)ifStatement.keyword(), (Tree)elseClause.body())});
        TextEditUtils.shiftLeft((StatementList)elseClause.body()).stream().skip(1L).forEach(xva$0 -> builder.addTextEdit(new PythonTextEdit[]{xva$0}));
        return builder.build();
    }

    private static boolean hasSideEffect(IfStatement ifStatement) {
        if (AllBranchesAreIdenticalCheck.containsPossibleSideEffect(ifStatement.condition())) {
            return true;
        }
        return ifStatement.elifBranches().stream().map(IfStatement::condition).anyMatch(AllBranchesAreIdenticalCheck::containsPossibleSideEffect);
    }

    private static boolean containsPossibleSideEffect(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return true;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return AllBranchesAreIdenticalCheck.containsPossibleSideEffect(binaryExpression.leftOperand()) || AllBranchesAreIdenticalCheck.containsPossibleSideEffect(binaryExpression.rightOperand());
        }
        if (expression instanceof ParenthesizedExpression) {
            return AllBranchesAreIdenticalCheck.containsPossibleSideEffect(((ParenthesizedExpression)expression).expression());
        }
        return false;
    }
}

