/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractStringFormatCheck;
import org.sonar.python.checks.StringFormat;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S3457")
public class StringFormatCorrectnessCheck
extends AbstractStringFormatCheck {
    private static final Set<String> LOGGER_FULL_NAMES = new HashSet<String>(Arrays.asList("logging.debug", "logging.info", "logging.warning", "logging.error", "logging.critical", "logging.Logger.debug", "logging.Logger.info", "logging.Logger.warning", "logging.Logger.error", "logging.Logger.critical"));
    private static final Set<String> LOGGER_METHOD_NAMES = new HashSet<String>(Arrays.asList("debug", "info", "warning", "error", "critical"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.MODULO, this::checkPrintfStyle);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, StringFormatCorrectnessCheck::checkFStringLiteral);
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (StringFormatCorrectnessCheck.isCallToLog(callExpression)) {
            StringFormatCorrectnessCheck.checkLoggerLog(ctx, callExpression);
        } else {
            this.checkStrFormatStyle(ctx);
        }
    }

    private static boolean isCallToLog(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol != null && LOGGER_FULL_NAMES.contains(symbol.fullyQualifiedName())) {
            return true;
        }
        return StringFormatCorrectnessCheck.isQualifiedCallToLogger(callExpression);
    }

    private static boolean isQualifiedCallToLogger(CallExpression callExpression) {
        if (!callExpression.callee().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return false;
        }
        QualifiedExpression qualifiedExpression = (QualifiedExpression)callExpression.callee();
        if (!LOGGER_METHOD_NAMES.contains(qualifiedExpression.name().name())) {
            return false;
        }
        Expression qualifier = qualifiedExpression.qualifier();
        if (!qualifier.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return false;
        }
        Expression singleAssignedValue = Expressions.singleAssignedValue((Name)qualifier);
        if (singleAssignedValue == null || !singleAssignedValue.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return false;
        }
        CallExpression call = (CallExpression)singleAssignedValue;
        Symbol symbol = call.calleeSymbol();
        if (symbol == null) {
            return false;
        }
        return "logging.getLogger".equals(symbol.fullyQualifiedName());
    }

    private static void checkFStringLiteral(SubscriptionContext ctx) {
        StringLiteral literal = (StringLiteral)ctx.syntaxNode();
        List fStrings = literal.stringElements().stream().filter(stringElement -> stringElement.prefix().toLowerCase(Locale.ENGLISH).contains("f")).collect(Collectors.toList());
        if (!fStrings.isEmpty() && fStrings.stream().allMatch(str -> str.formattedExpressions().isEmpty())) {
            ctx.addIssue((Tree)literal, "Add replacement fields or use a normal string instead of an f-string.");
        }
    }

    private static void checkLoggerLog(SubscriptionContext ctx, CallExpression callExpression) {
        if (callExpression.arguments().isEmpty() || callExpression.arguments().stream().anyMatch(argument -> !argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT}))) {
            return;
        }
        List<RegularArgument> arguments = callExpression.arguments().stream().map(RegularArgument.class::cast).filter(argument -> argument.keywordArgument() == null).collect(Collectors.toList());
        if (arguments.isEmpty()) {
            return;
        }
        Expression firstArgument = ((RegularArgument)arguments.get(0)).expression();
        StringLiteral literal = StringFormatCorrectnessCheck.extractStringLiteral((Tree)firstArgument);
        if (literal == null) {
            return;
        }
        if (arguments.size() == 1) {
            StringFormat.createFromPrintfStyle(IGNORE_SYNTAX_ERRORS, literal.trimmedQuotesValue()).ifPresent(format -> {
                if (format.numExpectedArguments() != 0L) {
                    StringFormatCorrectnessCheck.reportIssue(ctx, (Tree)firstArgument, (Tree)literal, "Add argument(s) corresponding to the message's replacement field(s).");
                }
            });
            return;
        }
        Optional<StringFormat> formatOptional = StringFormat.createFromPrintfStyle(StringFormatCorrectnessCheck.syntaxIssueReporter(ctx, (Tree)firstArgument, (Tree)literal), literal.trimmedQuotesValue());
        if (!formatOptional.isPresent()) {
            return;
        }
        StringFormat format2 = formatOptional.get();
        Token argIssueFrom = ((RegularArgument)arguments.get(1)).firstToken();
        Token argIssueTo = ((RegularArgument)arguments.get(arguments.size() - 1)).lastToken();
        if (format2.hasNamedFields()) {
            StringFormatCorrectnessCheck.checkNamed(ctx, arguments, format2, argIssueFrom, argIssueTo);
        } else {
            List<Expression> expressions = arguments.subList(1, arguments.size()).stream().map(RegularArgument::expression).collect(Collectors.toList());
            StringFormatCorrectnessCheck.checkPrintfExpressionList(ctx, format2, argIssueFrom, argIssueTo, expressions);
        }
    }

    private static void checkNamed(SubscriptionContext ctx, List<RegularArgument> arguments, StringFormat format, Token argIssueFrom, Token argIssueTo) {
        Expression second = arguments.get(1).expression();
        if (!StringFormatCorrectnessCheck.isMapping(second)) {
            ctx.addIssue(argIssueFrom, argIssueTo, "Replace formatting argument(s) with a mapping; Replacement fields are named.");
            return;
        }
        if (arguments.size() > 2) {
            ctx.addIssue(argIssueFrom, argIssueTo, "Change formatting arguments; the formatted string expects a single mapping.");
            return;
        }
        if (second.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            StringFormatCorrectnessCheck.checkPrintfDictionary(ctx, format, (DictionaryLiteral)second);
        }
    }

    @Override
    protected void checkPrintfStyle(SubscriptionContext ctx, BinaryExpression modulo, StringLiteral literal) {
        Optional<StringFormat> formatOptional = StringFormat.createFromPrintfStyle(IGNORE_SYNTAX_ERRORS, literal.trimmedQuotesValue());
        if (!formatOptional.isPresent()) {
            return;
        }
        StringFormat format = formatOptional.get();
        if (!StringFormatCorrectnessCheck.isInterestingDictLiteral(modulo.rightOperand())) {
            return;
        }
        DictionaryLiteral dict = (DictionaryLiteral)modulo.rightOperand();
        List allNames = format.replacementFields().stream().filter(StringFormat.ReplacementField::isNamed).map(StringFormat.ReplacementField::name).collect(Collectors.toList());
        dict.elements().stream().map(KeyValuePair.class::cast).map(kv -> (StringLiteral)kv.key()).filter(key -> !allNames.contains(key.trimmedQuotesValue())).forEach(key -> ctx.addIssue((Tree)key, "Remove this unused argument or add a replacement field."));
    }

    private static boolean isInterestingDictLiteral(Expression expression) {
        if (!expression.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            return false;
        }
        DictionaryLiteral dict = (DictionaryLiteral)expression;
        for (DictionaryLiteralElement element : dict.elements()) {
            if (!element.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR})) {
                return false;
            }
            if (((KeyValuePair)element).key().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void checkStrFormatStyle(SubscriptionContext ctx, CallExpression callExpression, Expression qualifier, StringLiteral literal) {
        if (callExpression.arguments().stream().anyMatch(argument -> !argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT}))) {
            return;
        }
        Optional<StringFormat> formatOptional = StringFormat.createFromStrFormatStyle(IGNORE_SYNTAX_ERRORS, literal.trimmedQuotesValue());
        if (!formatOptional.isPresent()) {
            return;
        }
        StringFormat format = formatOptional.get();
        List arguments = callExpression.arguments().stream().map(RegularArgument.class::cast).collect(Collectors.toList());
        int firstKwIdx = IntStream.range(0, arguments.size()).filter(idx -> ((RegularArgument)arguments.get(idx)).keywordArgument() != null).findFirst().orElse(arguments.size());
        IntStream.range((int)format.numExpectedPositional(), firstKwIdx).mapToObj(arguments::get).forEach(argument -> ctx.addIssue((Tree)argument, "Remove this unused argument."));
        HashSet<RegularArgument> unmatchedKeywordArgs = new HashSet<RegularArgument>(arguments.subList(firstKwIdx, arguments.size()));
        format.replacementFields().stream().filter(StringFormat.ReplacementField::isNamed).map(StringFormat.ReplacementField::name).forEach(name -> unmatchedKeywordArgs.removeIf(argument -> name.equals(argument.keywordArgument().name())));
        unmatchedKeywordArgs.forEach(argument -> ctx.addIssue((Tree)argument, "Remove this unused argument."));
    }
}

