/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.checks.AbstractUnreadPrivateMembersCheck;
import org.sonar.python.semantic.BuiltinSymbols;

@Rule(key="S1144")
public class UnreadPrivateMethodsCheck
extends AbstractUnreadPrivateMembersCheck {
    @Override
    String memberPrefix() {
        return "__";
    }

    @Override
    Symbol.Kind kind() {
        return Symbol.Kind.FUNCTION;
    }

    @Override
    String message(String memberName) {
        return "Remove this unused class-private '" + memberName + "' method.";
    }

    @Override
    String secondaryMessage() {
        return null;
    }

    @Override
    protected boolean isException(Symbol symbol) {
        return Optional.of(symbol).filter(FunctionSymbol.class::isInstance).map(FunctionSymbol.class::cast).map(FunctionSymbol::decorators).stream().flatMap(Collection::stream).anyMatch(Predicate.not(BuiltinSymbols.STATIC_AND_CLASS_METHOD_DECORATORS::contains));
    }

    @Override
    protected boolean hasAmbiguousUsage(Symbol symbol, ClassDef classDef) {
        CallNamesVisitor visitor = new CallNamesVisitor(symbol.name());
        classDef.accept((TreeVisitor)visitor);
        return visitor.usages > 1;
    }

    private static class CallNamesVisitor
    extends BaseTreeVisitor {
        private final String name;
        private int usages = 0;

        public CallNamesVisitor(String name) {
            this.name = name;
        }

        public void visitName(Name pyNameTree) {
            if (this.name.equals(pyNameTree.name())) {
                ++this.usages;
            }
        }
    }
}

