/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6542")
public class UseOfAnyAsTypeHintCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a more specific type than `Any` for this type hint.";
    private static final Set<String> OVERRIDE_FQNS = Set.of("typing.override", "typing.overload");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInReturnTypeAndParameters);
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInReturnTypeAndParameters);
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInTypeHint);
    }

    private static void checkForAnyInTypeHint(SubscriptionContext ctx) {
        Optional.of((TypeAnnotation)ctx.syntaxNode()).filter(UseOfAnyAsTypeHintCheck::isTypeAny).ifPresent(typeAnnotation -> ctx.addIssue((Tree)typeAnnotation.expression(), MESSAGE));
    }

    private static void checkForAnyInReturnTypeAndParameters(SubscriptionContext ctx) {
        TypeAnnotation typeAnnotation = (TypeAnnotation)ctx.syntaxNode();
        Optional.of(typeAnnotation).filter(UseOfAnyAsTypeHintCheck::isTypeAny).map(annotation -> (FunctionDef)TreeUtils.firstAncestorOfKind((Tree)annotation, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF})).filter(Predicate.not(UseOfAnyAsTypeHintCheck::hasFunctionOverrideOrOverloadDecorator)).filter(Predicate.not(UseOfAnyAsTypeHintCheck::canFunctionBeAnOverride)).ifPresent(functionDef -> ctx.addIssue((Tree)typeAnnotation.expression(), MESSAGE));
    }

    private static boolean isTypeAny(@Nullable TypeAnnotation typeAnnotation) {
        return Optional.ofNullable(typeAnnotation).map(annotation -> "typing.Any".equals(TreeUtils.fullyQualifiedNameFromExpression((Expression)annotation.expression()))).orElse(false);
    }

    private static boolean hasFunctionOverrideOrOverloadDecorator(FunctionDef currentFunctionDef) {
        return currentFunctionDef.decorators().stream().map(Decorator::expression).map(TreeUtils::fullyQualifiedNameFromExpression).filter(Objects::nonNull).anyMatch(OVERRIDE_FQNS::contains);
    }

    private static boolean canFunctionBeAnOverride(FunctionDef currentMethodDef) {
        return Optional.ofNullable(TreeUtils.getFunctionSymbolFromDef((FunctionDef)currentMethodDef)).map(SymbolUtils::canBeAnOverridingMethod).orElse(false);
    }
}

