/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.RegularArgumentImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4830")
public class VerifiedSslTlsCertificateCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Enable server certificate validation on this SSL/TLS connection.";
    private static final String VERIFY_NONE = Fqn.ssl("VERIFY_NONE");
    private static final String SET_VERIFY = Fqn.context("set_verify");
    public static final Set<String> VERIFY_ARG_NAME = Set.of("verify");
    public static final Set<String> VERIFY_SSL_ARG_NAMES = Set.of("verify_ssl", "ssl");
    private static final Set<String> CALLS_WHERE_TO_ENFORCE_TRUE_ARGUMENT = Set.of("requests.api.request", "requests.api.get", "requests.api.head", "requests.api.post", "requests.api.put", "requests.api.delete", "requests.api.patch", "requests.api.options", "httpx.request", "httpx.stream", "httpx.get", "httpx.options", "httpx.head", "httpx.post", "httpx.put", "httpx.patch", "httpx.delete", "httpx.Client", "httpx.AsyncClient");
    private static final Set<String> NO_ARG_FALSY_COLLECTION_CONSTRUCTORS = new HashSet<String>(Arrays.asList("set", "list", "dict"));
    private static final Map<String, Boolean> VULNERABLE_CONTEXT_FACTORIES = Map.of("ssl._create_unverified_context", true, "ssl._create_stdlib_context", true, "ssl.create_default_context", false, "ssl._create_default_https_context", false);

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, VerifiedSslTlsCertificateCheck::verifyAioHttpWithSession);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, VerifiedSslTlsCertificateCheck::sslSetVerifyCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, VerifiedSslTlsCertificateCheck::requestsCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.REGULAR_ARGUMENT, VerifiedSslTlsCertificateCheck::standardSslCheckForRegularArgument);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, VerifiedSslTlsCertificateCheck::standardSslCheckForAssignmentStatement);
    }

    private static void verifyAioHttpWithSession(SubscriptionContext ctx) {
        WithStatement withStatement = (WithStatement)ctx.syntaxNode();
        withStatement.withItems().stream().filter(item -> Optional.of(item).map(WithItem::test).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter("aiohttp.ClientSession"::equals).isPresent()).map(WithItem::expression).map(TreeUtils.toOptionalInstanceOfMapper(Name.class)).filter(Optional::isPresent).map(Optional::get).map(HasSymbol::symbol).filter(Objects::nonNull).forEach(symbol -> VerifiedSslTlsCertificateCheck.verifyAioHttpSessionSymbolUsages(ctx, symbol));
    }

    private static void verifyAioHttpSessionSymbolUsages(SubscriptionContext ctx, Symbol sessionSymbol) {
        sessionSymbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.OTHER).map(Usage::tree).map(t -> TreeUtils.firstAncestorOfKind((Tree)t, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR})).map(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).filter(Optional::isPresent).map(Optional::get).forEach(sessionCallExpr -> VerifiedSslTlsCertificateCheck.verifyVulnerableMethods(ctx, sessionCallExpr, VERIFY_SSL_ARG_NAMES));
    }

    private static void sslSetVerifyCheck(SubscriptionContext subscriptionContext) {
        Tree flagsArgument;
        List args;
        CallExpression callExpr = (CallExpression)subscriptionContext.syntaxNode();
        boolean isSetVerifyInvocation = Optional.ofNullable(callExpr.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(SET_VERIFY::equals).isPresent();
        if (isSetVerifyInvocation && !(args = callExpr.arguments()).isEmpty() && (flagsArgument = (Tree)args.get(0)).is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            HashSet<QualifiedExpression> flags = VerifiedSslTlsCertificateCheck.extractFlags((Tree)((RegularArgumentImpl)flagsArgument).expression());
            VerifiedSslTlsCertificateCheck.checkFlagSettings(flags).ifPresent(issue -> subscriptionContext.addIssue(issue.token, MESSAGE));
        }
    }

    private static HashSet<QualifiedExpression> extractFlags(Tree flagsSubexpr) {
        if (flagsSubexpr.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return new HashSet<QualifiedExpression>(Collections.singletonList((QualifiedExpression)flagsSubexpr));
        }
        if (flagsSubexpr.is(new Tree.Kind[]{Tree.Kind.BITWISE_OR})) {
            BinaryExpression orExpr = (BinaryExpression)flagsSubexpr;
            HashSet<QualifiedExpression> flags = VerifiedSslTlsCertificateCheck.extractFlags((Tree)orExpr.leftOperand());
            flags.addAll(VerifiedSslTlsCertificateCheck.extractFlags((Tree)orExpr.rightOperand()));
            return flags;
        }
        return new HashSet<QualifiedExpression>();
    }

    private static Optional<IssueReport> checkFlagSettings(Set<QualifiedExpression> flags) {
        for (QualifiedExpression qe : flags) {
            String fqn;
            Symbol symb = qe.symbol();
            if (symb == null || !VERIFY_NONE.equals(fqn = symb.fullyQualifiedName())) continue;
            return Optional.of(new IssueReport("Omitting the check of the peer certificate is dangerous.", qe.lastToken()));
        }
        return Optional.empty();
    }

    private static void requestsCheck(SubscriptionContext subscriptionContext) {
        CallExpression callExpr = (CallExpression)subscriptionContext.syntaxNode();
        boolean isVulnerableMethod = Optional.ofNullable(callExpr.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(CALLS_WHERE_TO_ENFORCE_TRUE_ARGUMENT::contains).isPresent();
        if (isVulnerableMethod) {
            VerifiedSslTlsCertificateCheck.verifyVulnerableMethods(subscriptionContext, callExpr, VERIFY_ARG_NAME);
        }
    }

    private static void verifyVulnerableMethods(SubscriptionContext ctx, CallExpression callExpr, Set<String> argumentNames) {
        Optional<List<Expression>> verifyRhs = VerifiedSslTlsCertificateCheck.searchVerifyAssignment(callExpr, argumentNames).or(() -> VerifiedSslTlsCertificateCheck.searchVerifyInKwargs(callExpr, argumentNames));
        verifyRhs.ifPresent(sensitiveSettingExpressions -> sensitiveSettingExpressions.stream().filter(rhs -> Expressions.isFalsy(rhs) || VerifiedSslTlsCertificateCheck.isFalsyCollection(rhs)).findFirst().ifPresent(rhs -> VerifiedSslTlsCertificateCheck.addIssue(ctx, sensitiveSettingExpressions, rhs)));
    }

    private static void addIssue(SubscriptionContext ctx, List<Expression> sensitiveSettingExpressions, Expression rhs) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)rhs, MESSAGE);
        sensitiveSettingExpressions.stream().filter(v -> v != rhs).forEach(v -> issue.secondary((Tree)v, "Dictionary is passed here as **kwargs."));
    }

    private static Optional<List<Expression>> searchVerifyAssignment(CallExpression callExpr, Set<String> argumentNames) {
        List args = callExpr.arguments().stream().filter(RegularArgument.class::isInstance).map(RegularArgument.class::cast).filter(regArg -> Optional.of(regArg).map(RegularArgument::keywordArgument).map(Name::name).filter(argumentNames::contains).isPresent()).map(RegularArgument::expression).collect(Collectors.toList());
        return Optional.of(args).filter(Predicate.not(List::isEmpty));
    }

    private static Optional<List<Expression>> searchVerifyInKwargs(CallExpression callExpression, Set<String> argumentNames) {
        return callExpression.arguments().stream().filter(UnpackingExpression.class::isInstance).map(arg -> ((UnpackingExpression)arg).expression()).filter(Name.class::isInstance).findFirst().flatMap(name -> Optional.ofNullable(Expressions.singleAssignedValue((Name)name)).filter(DictionaryLiteral.class::isInstance).flatMap(dict -> VerifiedSslTlsCertificateCheck.searchDangerousVerifySettingInDictionary((DictionaryLiteral)dict, argumentNames).map(settingInDict -> Arrays.asList(name, settingInDict))));
    }

    private static Optional<Expression> searchDangerousVerifySettingInDictionary(DictionaryLiteral dict, Set<String> argumentNames) {
        return dict.elements().stream().filter(KeyValuePair.class::isInstance).map(KeyValuePair.class::cast).filter(kvp -> Optional.of(kvp.key()).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).filter(argumentNames::contains).isPresent()).findFirst().map(KeyValuePair::value);
    }

    private static boolean isFalsyCollection(Expression expr) {
        CallExpression callExpr;
        Optional<String> fqnOpt;
        if (expr instanceof CallExpression && (fqnOpt = Optional.ofNullable((callExpr = (CallExpression)expr).calleeSymbol()).map(Symbol::fullyQualifiedName)).isPresent()) {
            String fqn = fqnOpt.get();
            return VerifiedSslTlsCertificateCheck.isFalsyNoArgCollectionConstruction(callExpr, fqn) || VerifiedSslTlsCertificateCheck.isFalsyRange(callExpr, fqn);
        }
        return false;
    }

    private static boolean isFalsyNoArgCollectionConstruction(CallExpression callExpr, String fqn) {
        return NO_ARG_FALSY_COLLECTION_CONSTRUCTORS.contains(fqn) && callExpr.arguments().isEmpty();
    }

    private static boolean isFalsyRange(CallExpression callExpr, String fqn) {
        RegularArgument regArg;
        Expression firstArgExpr;
        Argument firstArg;
        if ("range".equals(fqn) && callExpr.arguments().size() == 1 && (firstArg = (Argument)callExpr.arguments().get(0)) instanceof RegularArgument && (firstArgExpr = (regArg = (RegularArgument)firstArg).expression()).is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            NumericLiteral num = (NumericLiteral)firstArgExpr;
            return num.valueAsLong() == 0L;
        }
        return false;
    }

    private static void standardSslCheckForAssignmentStatement(SubscriptionContext subscriptionContext) {
        AssignmentStatement asgnStmt = (AssignmentStatement)subscriptionContext.syntaxNode();
        Optional<VulnerabilityAndProblematicToken> vulnTokOpt = VerifiedSslTlsCertificateCheck.isVulnerableMethodCall(asgnStmt.assignedValue());
        vulnTokOpt.ifPresent(vulnTok -> asgnStmt.lhsExpressions().stream().flatMap(it -> it.expressions().stream()).findFirst().filter(Name.class::isInstance).map(expr -> ((Name)expr).symbol()).ifPresent(symb -> {
            for (Usage u : VerifiedSslTlsCertificateCheck.selectRelevantModifyingUsages(symb.usages(), vulnTok.token.line())) {
                VerifiedSslTlsCertificateCheck.searchForVerifyModeOverride(u).ifPresent(vulnTok::overrideBy);
            }
            if (vulnTok.isVulnerable) {
                subscriptionContext.addIssue(vulnTok.token, MESSAGE);
            }
        }));
    }

    private static void standardSslCheckForRegularArgument(SubscriptionContext subscriptionContext) {
        RegularArgument argument = (RegularArgument)subscriptionContext.syntaxNode();
        VerifiedSslTlsCertificateCheck.isVulnerableMethodCall(argument.expression()).ifPresent(vulnTok -> subscriptionContext.addIssue(vulnTok.token, MESSAGE));
    }

    private static int findNextAssignmentLine(List<Usage> usages, int firstAssignmentLine) {
        int closestHigher = Integer.MAX_VALUE;
        for (Usage u : usages) {
            int line;
            if (!u.isBindingUsage() || (line = u.tree().firstToken().line()) <= firstAssignmentLine || line > closestHigher) continue;
            closestHigher = line;
        }
        return closestHigher;
    }

    private static List<Usage> selectRelevantModifyingUsages(List<Usage> usages, int firstAssignmentLine) {
        int nextAssignmentLine = VerifiedSslTlsCertificateCheck.findNextAssignmentLine(usages, firstAssignmentLine);
        ArrayList<Usage> result = new ArrayList<Usage>();
        usages.stream().filter(u -> {
            int line = u.tree().firstToken().line();
            return !u.isBindingUsage() && line > firstAssignmentLine && line < nextAssignmentLine;
        }).forEach(u -> result.add((Usage)u));
        result.sort(Comparator.comparing(u -> u.tree().firstToken().line()));
        return result;
    }

    private static Optional<VulnerabilityAndProblematicToken> isVulnerableMethodCall(Expression expr) {
        String fqn;
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expr instanceof CallExpression && (calleeSymbol = (callExpression = (CallExpression)expr).calleeSymbol()) != null && (fqn = calleeSymbol.fullyQualifiedName()) != null && VULNERABLE_CONTEXT_FACTORIES.containsKey(fqn)) {
            boolean isVulnerable = VULNERABLE_CONTEXT_FACTORIES.get(fqn);
            return Optional.of(new VulnerabilityAndProblematicToken(isVulnerable, callExpression.callee().lastToken(), true));
        }
        return Optional.empty();
    }

    private static Optional<VulnerabilityAndProblematicToken> searchForVerifyModeOverride(Usage u) {
        if (!u.isBindingUsage()) {
            return Optional.of(u).map(Usage::tree).map(Tree::parent).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).filter(qe -> "verify_mode".equals(qe.name().name())).map(Tree::parent).map(Tree::parent).filter(AssignmentStatement.class::isInstance).map(ae -> ((AssignmentStatement)ae).assignedValue()).filter(QualifiedExpression.class::isInstance).flatMap(qe -> Optional.ofNullable(((QualifiedExpression)qe).symbol()).map(symb -> new VulnerabilityAndProblematicToken("ssl.CERT_NONE".equals(symb.fullyQualifiedName()), qe.lastToken(), false)));
        }
        return Optional.empty();
    }

    private static class IssueReport {
        final String message;
        final Token token;

        private IssueReport(String message, Token token) {
            this.message = message;
            this.token = token;
        }
    }

    private static class VulnerabilityAndProblematicToken {
        boolean isInvisibleDefaultPreset;
        boolean isVulnerable;
        Token token;

        VulnerabilityAndProblematicToken(boolean isVulnerable, Token token, boolean isInvisibleDefaultPreset) {
            this.isVulnerable = isVulnerable;
            this.token = token;
            this.isInvisibleDefaultPreset = isInvisibleDefaultPreset;
        }

        void overrideBy(VulnerabilityAndProblematicToken overridingAssignment) {
            this.isInvisibleDefaultPreset = false;
            this.isVulnerable = overridingAssignment.isVulnerable;
            this.token = overridingAssignment.token;
        }
    }

    private static class Fqn {
        private Fqn() {
        }

        private static String context(String method) {
            return Fqn.ssl("Context." + method);
        }

        private static String ssl(String property) {
            return "OpenSSL.SSL." + property;
        }
    }
}

