/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S5443")
public class PubliclyWritableDirectoriesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure publicly writable directories are used safely here.";
    private static final List<String> UNIX_WRITABLE_DIRECTORIES = Arrays.asList("/tmp/", "/var/tmp/", "/usr/tmp/", "/dev/shm/", "/dev/mqueue/", "/run/lock/", "/var/run/lock/", "/library/caches/", "/users/shared/", "/private/tmp/", "/private/var/tmp/");
    private static final List<String> NONCOMPLIANT_ENVIRON_VARIABLES = Arrays.asList("tmpdir", "tmp");
    private static final Pattern WINDOWS_WRITABLE_DIRECTORIES = Pattern.compile("[^\\\\]*\\\\(Windows\\\\Temp|Temp|TMP)(\\\\.*|$)", 2);

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, ctx -> {
            StringElement tree = (StringElement)ctx.syntaxNode();
            String stringElement = Expressions.unescape(tree).toLowerCase(Locale.ENGLISH);
            if (UNIX_WRITABLE_DIRECTORIES.stream().anyMatch(dir -> PubliclyWritableDirectoriesCheck.containsDirectory(stringElement, dir)) || WINDOWS_WRITABLE_DIRECTORIES.matcher(stringElement).matches()) {
                ctx.addIssue((Tree)tree, MESSAGE);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression tree = (CallExpression)ctx.syntaxNode();
            List arguments = tree.arguments();
            if (PubliclyWritableDirectoriesCheck.isOsEnvironGetter(tree)) {
                if (arguments.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(RegularArgument.class::cast).map(RegularArgument::expression).anyMatch(PubliclyWritableDirectoriesCheck::isNonCompliantOsEnvironArgument)) {
                    ctx.addIssue((Tree)tree, MESSAGE);
                }
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.SUBSCRIPTION, ctx -> {
            SubscriptionExpression tree = (SubscriptionExpression)ctx.syntaxNode();
            if (PubliclyWritableDirectoriesCheck.isOsEnvironQualifiedExpression(tree.object()) && tree.subscripts().expressions().stream().anyMatch(PubliclyWritableDirectoriesCheck::isNonCompliantOsEnvironArgument)) {
                ctx.addIssue((Tree)tree, MESSAGE);
            }
        });
    }

    private static boolean containsDirectory(String stringElement, String dir) {
        return stringElement.startsWith(dir) || stringElement.equals(dir.substring(0, dir.length() - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNonCompliantOsEnvironArgument(Expression expression) {
        if (!expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) return false;
        if (!((StringLiteral)expression).stringElements().stream().map(s -> Expressions.unescape(s).toLowerCase(Locale.ENGLISH)).anyMatch(NONCOMPLIANT_ENVIRON_VARIABLES::contains)) return false;
        return true;
    }

    private static boolean isOsEnvironGetter(CallExpression callExpressionTree) {
        Symbol symbol = callExpressionTree.calleeSymbol();
        return symbol != null && "os.environ.get".equals(symbol.fullyQualifiedName());
    }

    private static boolean isOsEnvironQualifiedExpression(Expression expression) {
        Symbol symbol;
        if (expression instanceof HasSymbol && (symbol = ((HasSymbol)expression).symbol()) != null) {
            return "os.environ".equals(symbol.fullyQualifiedName());
        }
        return false;
    }
}

