/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonar.python.regex.RegexContext;
import org.sonar.python.tree.TreeUtils;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public abstract class AbstractRegexCheck
extends PythonSubscriptionCheck {
    private static final Map<String, Integer> REGEX_FUNCTIONS_TO_FLAG_PARAM = new HashMap<String, Integer>();
    protected RegexContext regexContext;
    protected final Set<RegexSyntaxElement> reportedRegexTrees = new HashSet<RegexSyntaxElement>();

    protected Map<String, Integer> lookedUpFunctions() {
        return REGEX_FUNCTIONS_TO_FLAG_PARAM;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCall);
    }

    public abstract void checkRegex(RegexParseResult var1, CallExpression var2);

    private void checkCall(SubscriptionContext ctx) {
        this.regexContext = (RegexContext)ctx;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null || calleeSymbol.fullyQualifiedName() == null) {
            return;
        }
        String functionFqn = calleeSymbol.fullyQualifiedName();
        if (functionFqn != null && this.lookedUpFunctions().containsKey(functionFqn)) {
            FlagSet flagSet = this.getFlagSet(callExpression, functionFqn);
            AbstractRegexCheck.patternArgStringLiteral(callExpression).flatMap(l -> this.regexForStringLiteral((StringLiteral)l, flagSet)).ifPresent(parseResult -> this.checkRegex((RegexParseResult)parseResult, callExpression));
        }
    }

    private Optional<RegexParseResult> regexForStringLiteral(StringLiteral literal, FlagSet flagSet) {
        if (AbstractRegexCheck.shouldHandleStringLiteral(literal)) {
            return Optional.of(this.regexContext.regexForStringElement((StringElement)literal.stringElements().get(0), flagSet));
        }
        return Optional.empty();
    }

    private static boolean shouldHandleStringLiteral(StringLiteral literal) {
        if (literal.stringElements().size() != 1) {
            return false;
        }
        StringElement stringElement = (StringElement)literal.stringElements().get(0);
        return stringElement.formattedExpressions().isEmpty() && (stringElement.prefix().toLowerCase(Locale.ROOT).contains("r") || !stringElement.value().contains("\\N{"));
    }

    private static Optional<StringLiteral> patternArgStringLiteral(CallExpression regexFunctionCall) {
        RegularArgument patternArgument = TreeUtils.nthArgumentOrKeyword((int)0, (String)"pattern", (List)regexFunctionCall.arguments());
        if (patternArgument == null) {
            return Optional.empty();
        }
        Expression patternValueExpression = patternArgument.expression();
        if (patternValueExpression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            patternValueExpression = Expressions.singleAssignedValue((Name)patternValueExpression);
        }
        if (patternValueExpression != null && patternValueExpression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return Optional.of((StringLiteral)patternValueExpression);
        }
        return Optional.empty();
    }

    private FlagSet getFlagSet(CallExpression callExpression, String functionFqn) {
        HashSet flags = new HashSet();
        AbstractRegexCheck.getFlagsArgValue(callExpression, this.lookedUpFunctions().get(functionFqn)).ifPresent(f -> flags.addAll(AbstractRegexCheck.extractFlagExpressions((Tree)f)));
        FlagSet flagSet = new FlagSet();
        flags.stream().map(AbstractRegexCheck::mapPythonFlag).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((FlagSet)flagSet).add(arg_0));
        if (!flagSet.contains(16)) {
            flagSet.add(256);
            flagSet.add(64);
        }
        flagSet.removeAll(new FlagSet(16));
        return flagSet;
    }

    private static Optional<Expression> getFlagsArgValue(CallExpression regexFunctionCall, @Nullable Integer argPosition) {
        if (argPosition == null) {
            return Optional.empty();
        }
        RegularArgument patternArgument = TreeUtils.nthArgumentOrKeyword((int)argPosition, (String)"flags", (List)regexFunctionCall.arguments());
        return patternArgument != null ? Optional.of(patternArgument.expression()) : Optional.empty();
    }

    private static HashSet<QualifiedExpression> extractFlagExpressions(Tree flagsSubexpr) {
        if (flagsSubexpr.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return new HashSet<QualifiedExpression>(Collections.singletonList((QualifiedExpression)flagsSubexpr));
        }
        if (flagsSubexpr.is(new Tree.Kind[]{Tree.Kind.BITWISE_OR})) {
            BinaryExpression orExpr = (BinaryExpression)flagsSubexpr;
            HashSet<QualifiedExpression> flags = AbstractRegexCheck.extractFlagExpressions((Tree)orExpr.leftOperand());
            flags.addAll(AbstractRegexCheck.extractFlagExpressions((Tree)orExpr.rightOperand()));
            return flags;
        }
        return new HashSet<QualifiedExpression>();
    }

    public static Optional<Integer> mapPythonFlag(QualifiedExpression ch) {
        Integer result;
        Symbol symbol = ch.symbol();
        if (symbol == null) {
            return Optional.empty();
        }
        String symbolFqn = symbol.fullyQualifiedName();
        if (symbolFqn == null) {
            return Optional.empty();
        }
        switch (symbolFqn) {
            case "re.IGNORECASE": 
            case "re.I": {
                result = 2;
                break;
            }
            case "re.MULTILINE": 
            case "re.M": {
                result = 8;
                break;
            }
            case "re.DOTALL": 
            case "re.S": {
                result = 32;
                break;
            }
            case "re.VERBOSE": 
            case "re.X": {
                result = 4;
                break;
            }
            case "re.UNICODE": 
            case "re.U": {
                result = 256;
                break;
            }
            case "re.ASCII": 
            case "re.A": {
                result = 16;
                break;
            }
            default: {
                result = null;
            }
        }
        return Optional.ofNullable(result);
    }

    public PythonCheck.PreciseIssue addIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        if (this.reportedRegexTrees.add(regexTree)) {
            PythonCheck.PreciseIssue issue = this.regexContext.addIssue(regexTree, message);
            secondaries.stream().map(PythonRegexIssueLocation::preciseLocation).forEach(arg_0 -> ((PythonCheck.PreciseIssue)issue).secondary(arg_0));
            return issue;
        }
        return null;
    }

    static {
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.sub", 4);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.subn", 4);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.compile", 1);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.search", 2);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.match", 2);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.fullmatch", 2);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.split", 3);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.findall", 2);
        REGEX_FUNCTIONS_TO_FLAG_PARAM.put("re.finditer", 2);
    }
}

