/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonar.python.tree.TreeUtils;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5860")
public class UnusedGroupNamesCheck
extends AbstractRegexCheck {
    private static final Set<String> MATCH_CREATION_FUNCTION_NAMES = Set.of("re.match", "re.fullmatch", "re.search");
    private static final Set<String> COMPILE_FUNCTION_NAMES = Set.of("re.compile");
    private static final String GROUP_NAME_DOESNT_EXISTS_MESSAGE_FORMAT = "There is no group named '%s' in the regular expression.";
    private static final String USE_NAME_INSTEAD_OF_NUMBER_MESSAGE_FORMAT = "Directly use '%s' instead of its group number.";
    private static final String GROUP_NAME_SECONDARY_MESSAGE_FORMAT = "Named group '%s'";
    private static final String GROUP_NUMBER_SECONDARY_MESSAGE_FORMAT = "Group %d";
    private static final String NO_GROUP_NAMES_SECONDARY_MESSAGE = "No named groups defined in this regular expression.";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        KnownGroupsCollector groupsCollector = new KnownGroupsCollector();
        groupsCollector.visit(regexParseResult);
        UnusedGroupNamesCheck.getCallExpressionResultUsages(regexFunctionCall, COMPILE_FUNCTION_NAMES).map(patternUsages -> UnusedGroupNamesCheck.getUsagesQualifiedExpressions(patternUsages, "re.Pattern.match").map(qe -> TreeUtils.firstAncestorOfKind((Tree)qe, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})).filter(Objects::nonNull).map(AssignmentStatement.class::cast).map(UnusedGroupNamesCheck::getAssignmentResultUsages).filter(UnusedGroupNamesCheck::isSingleAssignment).flatMap(Collection::stream).collect(Collectors.toList())).or(() -> UnusedGroupNamesCheck.getCallExpressionResultUsages(regexFunctionCall, MATCH_CREATION_FUNCTION_NAMES)).ifPresent(matchUsages -> this.checkGroupAccesses(regexParseResult, groupsCollector, (List<Usage>)matchUsages));
    }

    private static Optional<List<Usage>> getCallExpressionResultUsages(CallExpression regexFunctionCall, Set<String> expressionFQNs) {
        return Optional.of(regexFunctionCall).filter(c -> expressionFQNs.contains(TreeUtils.fullyQualifiedNameFromExpression((Expression)c))).map(call -> TreeUtils.firstAncestorOfKind((Tree)call, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})).map(AssignmentStatement.class::cast).map(UnusedGroupNamesCheck::getAssignmentResultUsages).filter(UnusedGroupNamesCheck::isSingleAssignment);
    }

    private static boolean isSingleAssignment(List<Usage> usages) {
        return UnusedGroupNamesCheck.getAssignmentsCount(usages) == 1L;
    }

    private static long getAssignmentsCount(List<Usage> usages) {
        return usages.stream().map(Usage::kind).filter(kind -> kind == Usage.Kind.ASSIGNMENT_LHS).count();
    }

    private void checkGroupAccesses(RegexParseResult regexParseResult, KnownGroupsCollector groupsCollector, List<Usage> matchUsages) {
        UnusedGroupNamesCheck.getUsagesQualifiedExpressions(matchUsages, "re.Match.group").map(qe -> TreeUtils.firstAncestorOfKind((Tree)qe, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR})).filter(Objects::nonNull).map(CallExpression.class::cast).map(CallExpression::arguments).flatMap(Collection::stream).filter(RegularArgument.class::isInstance).map(RegularArgument.class::cast).map(RegularArgument::expression).forEach(argumentExpression -> this.checkValidGroupNameAccess(regexParseResult, groupsCollector, (Expression)argumentExpression));
    }

    private void checkValidGroupNameAccess(RegexParseResult regexParseResult, KnownGroupsCollector groupsCollector, Expression argumentExpression) {
        Optional.of(argumentExpression).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).filter(Predicate.not(groupsCollector.byName::containsKey)).ifPresent(nonExistingGroupName -> {
            String message = UnusedGroupNamesCheck.getGroupNameNotExistsMessage(nonExistingGroupName);
            PythonCheck.PreciseIssue issue = this.regexContext.addIssue((Tree)argumentExpression, message);
            if (groupsCollector.byName.isEmpty()) {
                IssueLocation secondaryLocation = PythonRegexIssueLocation.preciseLocation((RegexSyntaxElement)regexParseResult.getResult(), (String)NO_GROUP_NAMES_SECONDARY_MESSAGE);
                issue.secondary(secondaryLocation);
            } else {
                groupsCollector.byName.forEach((groupName, group) -> {
                    String secondaryMessage = String.format(GROUP_NAME_SECONDARY_MESSAGE_FORMAT, groupName);
                    IssueLocation secondaryLocation = PythonRegexIssueLocation.preciseLocation((RegexSyntaxElement)group, (String)secondaryMessage);
                    issue.secondary(secondaryLocation);
                });
            }
        });
        Optional.of(argumentExpression).filter(NumericLiteral.class::isInstance).map(NumericLiteral.class::cast).map(NumericLiteral::valueAsLong).filter(groupsCollector.byNumber::containsKey).map(groupsCollector.byNumber::get).ifPresent(group -> {
            String message = UnusedGroupNamesCheck.getUseNameInsteadNumberMessage(group);
            PythonCheck.PreciseIssue issue = this.regexContext.addIssue((Tree)argumentExpression, message);
            String secondaryMessage = String.format(GROUP_NUMBER_SECONDARY_MESSAGE_FORMAT, group.getGroupNumber());
            IssueLocation secondaryLocation = PythonRegexIssueLocation.preciseLocation((RegexSyntaxElement)group, (String)secondaryMessage);
            issue.secondary(secondaryLocation);
        });
    }

    private static String getUseNameInsteadNumberMessage(CapturingGroupTree capturingGroupTree) {
        String name = capturingGroupTree.getName().orElse(null);
        return String.format(USE_NAME_INSTEAD_OF_NUMBER_MESSAGE_FORMAT, name);
    }

    private static String getGroupNameNotExistsMessage(String groupName) {
        return String.format(GROUP_NAME_DOESNT_EXISTS_MESSAGE_FORMAT, groupName);
    }

    private static Stream<QualifiedExpression> getUsagesQualifiedExpressions(List<Usage> usages, String fullyQualifiedName) {
        return usages.stream().filter(usage -> usage.kind() == Usage.Kind.OTHER).map(Usage::tree).map(tree -> TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})).filter(Objects::nonNull).map(QualifiedExpression.class::cast).filter(qe -> Optional.of(qe.name()).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter(fullyQualifiedName::equals).isPresent());
    }

    private static List<Usage> getAssignmentResultUsages(AssignmentStatement assignment) {
        return assignment.lhsExpressions().stream().map(v -> TreeUtils.firstChild((Tree)v, Name.class::isInstance).map(Name.class::cast)).filter(Optional::isPresent).map(Optional::get).map(HasSymbol::symbol).filter(Objects::nonNull).map(Symbol::usages).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class KnownGroupsCollector
    extends RegexBaseVisitor {
        final Map<String, CapturingGroupTree> byName = new HashMap<String, CapturingGroupTree>();
        final Map<Long, CapturingGroupTree> byNumber = new HashMap<Long, CapturingGroupTree>();

        private KnownGroupsCollector() {
        }

        public void visitCapturingGroup(CapturingGroupTree tree) {
            tree.getName().ifPresent(name -> {
                this.byName.put((String)name, tree);
                this.byNumber.put(Long.valueOf(tree.getGroupNumber()), tree);
            });
            super.visitCapturingGroup(tree);
        }
    }
}

