/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5796")
public class IdentityComparisonWithNewObjectCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_IS = "Replace this \"is\" operator with \"==\".";
    public static final String IS_QUICK_FIX_MESSAGE = "Replace with \"==\"";
    public static final String IS_NOT_QUICK_FIX_MESSAGE = "Replace with \"!=\"";
    private static final String MESSAGE_IS_NOT = "Replace this \"is not\" operator with \"!=\".";
    private static final String MESSAGE_SECONDARY = "This expression creates a new object every time.";
    private static final Set<String> FUNCTIONS_RETURNING_UNIQUE_REF = new HashSet<String>(Arrays.asList("dict", "list", "set", "complex"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, IdentityComparisonWithNewObjectCheck::checkIsComparison);
    }

    private static void checkIsComparison(SubscriptionContext subscriptionContext) {
        InferredType t2;
        IsExpression isExpr = (IsExpression)subscriptionContext.syntaxNode();
        InferredType t1 = isExpr.leftOperand().type();
        if (!t1.isIdentityComparableWith(t2 = isExpr.rightOperand().type()) || t1.canOnlyBe("NoneType") || t2.canOnlyBe("NoneType")) {
            return;
        }
        if (!IdentityComparisonWithNewObjectCheck.checkOperand(isExpr.leftOperand(), isExpr, subscriptionContext)) {
            IdentityComparisonWithNewObjectCheck.checkOperand(isExpr.rightOperand(), isExpr, subscriptionContext);
        }
    }

    private static boolean checkOperand(Expression operand, IsExpression isExpr, SubscriptionContext ctx) {
        Optional<List<Tree>> secondariesOpt = IdentityComparisonWithNewObjectCheck.findIssueForOperand(operand);
        secondariesOpt.ifPresent(secondaryLocations -> {
            PythonCheck.PreciseIssue issue;
            Token notToken = isExpr.notToken();
            if (notToken != null) {
                quickFix = PythonQuickFix.newQuickFix((String)IS_NOT_QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)isExpr.operator(), (String)"!=")}).addTextEdit(new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)notToken, (Tree)isExpr.rightOperand())}).build();
                issue = ctx.addIssue(isExpr.operator(), notToken, MESSAGE_IS_NOT);
                issue.addQuickFix(quickFix);
            } else {
                quickFix = PythonQuickFix.newQuickFix((String)IS_QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)isExpr.operator(), (String)"==")}).build();
                issue = ctx.addIssue(isExpr.operator(), MESSAGE_IS);
                issue.addQuickFix(quickFix);
            }
            for (Tree secondary : secondaryLocations) {
                issue.secondary(secondary, MESSAGE_SECONDARY);
            }
        });
        return secondariesOpt.isPresent();
    }

    private static Optional<List<Tree>> findIssueForOperand(Expression expr) {
        Expression rhs;
        Name name;
        Symbol symb;
        if (IdentityComparisonWithNewObjectCheck.instantiatesFreshObject(expr)) {
            return Optional.of(Collections.emptyList());
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.NAME}) && (symb = (name = (Name)expr).symbol()) != null && (rhs = Expressions.singleAssignedValue((Name)expr)) != null && IdentityComparisonWithNewObjectCheck.instantiatesFreshObject(rhs) && IdentityComparisonWithNewObjectCheck.cannotEscape(symb)) {
            return Optional.of(Collections.singletonList(rhs));
        }
        return Optional.empty();
    }

    private static boolean instantiatesFreshObject(Expression expr) {
        switch (expr.getKind()) {
            case DICTIONARY_LITERAL: 
            case DICT_COMPREHENSION: 
            case LIST_LITERAL: 
            case LIST_COMPREHENSION: 
            case SET_LITERAL: 
            case SET_COMPREHENSION: {
                return true;
            }
            case CALL_EXPR: {
                Symbol calleeSymbol = ((CallExpression)expr).calleeSymbol();
                if (calleeSymbol != null) {
                    return FUNCTIONS_RETURNING_UNIQUE_REF.contains(calleeSymbol.fullyQualifiedName());
                }
                return false;
            }
        }
        return false;
    }

    private static boolean cannotEscape(Symbol symb) {
        List usages = symb.usages();
        if (usages.size() > 2) {
            return usages.stream().allMatch(u -> u.isBindingUsage() || TreeUtils.firstAncestorOfKind((Tree)u.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.IS}) != null);
        }
        return true;
    }
}

