/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6709")
public class NumpyRandomSeedCheck
extends PythonSubscriptionCheck {
    private static final String SEED_ARG_NAME = "seed";
    private static final Map<String, String> SEED_METHODS_TO_CHECK = Map.of("numpy.seed", "seed", "numpy.random.seed", "seed", "numpy.random.default_rng", "seed", "numpy.random.SeedSequence", "entropy", "numpy.random.PCG64", "seed", "numpy.random.PCG64DXSM", "seed", "numpy.random.MT19937", "seed", "numpy.random.SFC64", "seed", "numpy.random.Philox", "seed");
    private static final String MESSAGE = "Provide a seed for this random generator.";
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(ctx.pythonFile());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkEmptySeedCall);
    }

    private void checkEmptySeedCall(SubscriptionContext ctx) {
        CallExpression call = (CallExpression)ctx.syntaxNode();
        Optional.ofNullable(call.calleeSymbol()).map(Symbol::fullyQualifiedName).map(SEED_METHODS_TO_CHECK::get).filter(argName -> this.isSeedArgumentAbsentOrNone((String)argName, call.arguments())).ifPresent(fqn -> ctx.addIssue((Tree)call, MESSAGE));
    }

    private boolean isSeedArgumentAbsentOrNone(String argName, List<Argument> args) {
        RegularArgument arg = TreeUtils.nthArgumentOrKeyword((int)0, (String)argName, args);
        return arg == null || arg.expression().is(new Tree.Kind[]{Tree.Kind.NONE}) || this.isAssignedNone(arg.expression());
    }

    private boolean isAssignedNone(Expression exp) {
        return Optional.of(exp).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).map(arg_0 -> ((ReachingDefinitionsAnalysis)this.reachingDefinitionsAnalysis).valuesAtLocation(arg_0)).filter(Predicate.not(Set::isEmpty)).filter(values -> values.stream().allMatch(value -> value.is(new Tree.Kind[]{Tree.Kind.NONE}))).isPresent();
    }
}

