/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;

@Rule(key="S2245")
public class PseudoRandomCheck
extends PythonSubscriptionCheck {
    private static final Set<String> FUNCTION_NAMES = Set.of("random", "getrandbits", "randint", "sample", "choice", "choices", "randbytes", "randrange", "shuffle");
    private static final String RANDOM_PACKAGE_PREFIX = "random.";
    private static final String RANDOM_CLASS_PREFIX = "random.Random.";
    private static final Set<String> QUALIFIERS_TO_SKIP = Set.of("random.SystemRandom");
    private static final Set<String> FUNCTIONS_TO_CHECK = PseudoRandomCheck.getFunctionsFullyQualifiedNames();
    public static final String MESSAGE = "Make sure that using this pseudorandom number generator is safe here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            if (PseudoRandomCheck.skip(callExpression)) {
                return;
            }
            Symbol symbol = callExpression.calleeSymbol();
            Optional.ofNullable(symbol).map(Symbol::fullyQualifiedName).filter(FUNCTIONS_TO_CHECK::contains).ifPresent(functionFqn -> ctx.addIssue((Tree)callExpression, MESSAGE));
        });
    }

    private static Set<String> getFunctionsFullyQualifiedNames() {
        return FUNCTION_NAMES.stream().flatMap(functionName -> Stream.of(RANDOM_PACKAGE_PREFIX + functionName, RANDOM_CLASS_PREFIX + functionName)).collect(Collectors.toSet());
    }

    private static boolean skip(CallExpression callExpression) {
        return Optional.of(callExpression).map(CallExpression::callee).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).map(QualifiedExpression::qualifier).map(Expression::type).filter(type -> QUALIFIERS_TO_SKIP.stream().anyMatch(arg_0 -> ((InferredType)type).mustBeOrExtend(arg_0))).isPresent();
    }
}

