/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S2737")
public class ExceptRethrowingCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add logic to this except clause or eliminate it and rethrow the exception automatically.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TRY_STMT, ctx -> {
            TryStatement tryStatement = (TryStatement)ctx.syntaxNode();
            List exceptClauses = tryStatement.exceptClauses();
            if (exceptClauses.isEmpty()) {
                return;
            }
            ExceptClause exceptClause = (ExceptClause)exceptClauses.get(exceptClauses.size() - 1);
            if (!((Statement)exceptClause.body().statements().get(0)).is(new Tree.Kind[]{Tree.Kind.RAISE_STMT})) {
                return;
            }
            RaiseStatement raiseStatement = (RaiseStatement)exceptClause.body().statements().get(0);
            if (raiseStatement.expressions().isEmpty()) {
                ctx.addIssue((Tree)raiseStatement, MESSAGE);
                return;
            }
            if (exceptClause.exceptionInstance() != null) {
                Expression exceptionInstance = exceptClause.exceptionInstance();
                if (raiseStatement.expressions().size() == 1 && CheckUtils.areEquivalent((Tree)Expressions.removeParentheses(exceptionInstance), (Tree)Expressions.removeParentheses((Expression)raiseStatement.expressions().get(0)))) {
                    ctx.addIssue((Tree)raiseStatement, MESSAGE);
                }
            }
        });
    }
}

