/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6437")
public class HardcodedCredentialsCallCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Revoke and change this password, as it is compromised.";
    private final Map<String, CredentialMethod> methods = new CredentialMethodsLoader().load();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::processCallExpression);
    }

    private void processCallExpression(SubscriptionContext ctx) {
        Optional.of(ctx.syntaxNode()).filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(this::callHasToBeChecked).ifPresent(call -> this.checkCallArguments(ctx, (CallExpression)call));
    }

    private void checkCallArguments(SubscriptionContext ctx, CallExpression call) {
        this.getMethod(call).ifPresent(method -> method.indices().forEach(argumentIndex -> {
            String argumentName = method.args().get((int)argumentIndex);
            RegularArgument argument = TreeUtils.nthArgumentOrKeyword((int)argumentIndex, (String)argumentName, (List)call.arguments());
            if (argument != null) {
                HardcodedCredentialsCallCheck.checkArgument(ctx, argument);
            }
        }));
    }

    private static void checkArgument(SubscriptionContext ctx, RegularArgument argument) {
        Expression argExp = argument.expression();
        if (argExp.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            Optional.of(argExp).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).filter(HardcodedCredentialsCallCheck::isNotEmpty).ifPresent(string -> ctx.addIssue((Tree)argument, MESSAGE));
        } else if (argExp.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            HardcodedCredentialsCallCheck.findAssignment((Name)argExp, 0).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).filter(HardcodedCredentialsCallCheck::isNotEmpty).ifPresent(assignedValue -> ctx.addIssue((Tree)argument, MESSAGE).secondary((Tree)assignedValue, MESSAGE));
        }
    }

    private static boolean isNotEmpty(StringLiteral stringLiteral) {
        return Optional.of(stringLiteral).map(StringLiteral::trimmedQuotesValue).filter(Predicate.not(String::isEmpty)).isPresent();
    }

    private static Optional<Tree> findAssignment(Name name, int depth) {
        if (depth > 99) {
            return Optional.empty();
        }
        return Optional.of(name).map(Expressions::singleAssignedValue).map(v -> HardcodedCredentialsCallCheck.findValue(v, depth));
    }

    private static Tree findValue(Expression assignedValue, int depth) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return HardcodedCredentialsCallCheck.findAssignment((Name)assignedValue, depth + 1).orElse(null);
        }
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return Optional.of(assignedValue).filter(CallExpression.class::isInstance).map(CallExpression.class::cast).map(CallExpression::callee).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).map(QualifiedExpression::qualifier).map(v -> HardcodedCredentialsCallCheck.findValue(v, depth + 1)).orElse((Tree)assignedValue);
        }
        return assignedValue;
    }

    private Boolean callHasToBeChecked(CallExpression call) {
        return HardcodedCredentialsCallCheck.getMethodFqn(call).map(this.methods::containsKey).orElse(false);
    }

    private static Optional<String> getMethodFqn(CallExpression call) {
        return Optional.of(call).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName);
    }

    private Optional<CredentialMethod> getMethod(CallExpression call) {
        return HardcodedCredentialsCallCheck.getMethodFqn(call).map(this.methods::get);
    }

    private static class CredentialMethodsLoader {
        private static final String METHODS_RESOURCE_PATH = "/org/sonar/python/checks/hardcoded_credentials_call_check_meta.json";
        private final Gson gson = new Gson();

        private CredentialMethodsLoader() {
        }

        private Map<String, CredentialMethod> load() {
            Map<String, CredentialMethod> map;
            block8: {
                InputStream is = HardcodedCredentialsCallCheck.class.getResourceAsStream(METHODS_RESOURCE_PATH);
                try {
                    map = Optional.ofNullable(is).map(InputStreamReader::new).map(r -> (CredentialMethod[])this.gson.fromJson((Reader)r, CredentialMethod[].class)).stream().flatMap(Stream::of).collect(Collectors.toMap(CredentialMethod::name, Function.identity()));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to read methods metadata from /org/sonar/python/checks/hardcoded_credentials_call_check_meta.json", e);
                    }
                }
                is.close();
            }
            return map;
        }
    }

    public static class CredentialMethod {
        private String name;
        private List<String> args;
        private List<Integer> indices;

        public String name() {
            return this.name;
        }

        public List<String> args() {
            return this.args;
        }

        public List<Integer> indices() {
            return this.indices;
        }
    }
}

