/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5659")
public class JwtVerificationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't use a JWT token without verifying its signature.";
    private static final Set<String> PROCESS_JWT_FQNS = Set.of("python_jwt.process_jwt", "jwt.process_jwt");
    private static final Set<String> VERIFY_JWT_FQNS = Set.of("python_jwt.verify_jwt", "jwt.verify_jwt");
    private static final Set<String> WHERE_VERIFY_KWARG_SHOULD_BE_TRUE_FQNS = Set.of("jwt.decode", "jose.jws.verify");
    private static final Set<String> UNVERIFIED_FQNS = Set.of("jwt.get_unverified_header", "jose.jwt.get_unverified_header", "jose.jwt.get_unverified_headers", "jose.jws.get_unverified_header", "jose.jws.get_unverified_headers", "jose.jwt.get_unverified_claims", "jose.jws.get_unverified_claims");
    private static final String VERIFY_SIGNATURE_KEYWORD = "verify_signature";
    public static final Set<String> VERIFY_SIGNATURE_OPTION_SUPPORTING_FUNCTION_FQNS = Set.of("jose.jwt.decode", "jwt.decode");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, JwtVerificationCheck::verifyCallExpression);
    }

    private static void verifyCallExpression(SubscriptionContext ctx) {
        CallExpression call = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = call.calleeSymbol();
        if (calleeSymbol == null || calleeSymbol.fullyQualifiedName() == null) {
            return;
        }
        String calleeFqn = calleeSymbol.fullyQualifiedName();
        if (WHERE_VERIFY_KWARG_SHOULD_BE_TRUE_FQNS.contains(calleeFqn)) {
            RegularArgument verifyArg = TreeUtils.argumentByKeyword((String)"verify", (List)call.arguments());
            if (verifyArg != null && Expressions.isFalsy(verifyArg.expression())) {
                ctx.addIssue((Tree)verifyArg, MESSAGE);
                return;
            }
        } else if (PROCESS_JWT_FQNS.contains(calleeFqn)) {
            Optional.ofNullable(TreeUtils.firstAncestorOfKind((Tree)call, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FILE_INPUT, Tree.Kind.FUNCDEF})).filter(scriptOrFunction -> !TreeUtils.hasDescendant((Tree)scriptOrFunction, JwtVerificationCheck::isCallToVerifyJwt)).ifPresent(scriptOrFunction -> ctx.addIssue((Tree)call, MESSAGE));
        } else if (UNVERIFIED_FQNS.contains(calleeFqn)) {
            Optional.ofNullable(TreeUtils.nthArgumentOrKeyword((int)0, (String)"", (List)call.arguments())).flatMap(TreeUtils.toOptionalInstanceOfMapper(RegularArgument.class)).map(RegularArgument::expression).ifPresent(argument -> ctx.addIssue((Tree)argument, MESSAGE));
        }
        if (VERIFY_SIGNATURE_OPTION_SUPPORTING_FUNCTION_FQNS.contains(calleeFqn)) {
            Optional.ofNullable(TreeUtils.argumentByKeyword((String)"options", (List)call.arguments())).map(RegularArgument::expression).filter(JwtVerificationCheck::isListOrDictWithSensitiveEntry).ifPresent(expression -> ctx.addIssue((Tree)expression, MESSAGE));
        }
    }

    private static boolean isListOrDictWithSensitiveEntry(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return JwtVerificationCheck.isListOrDictWithSensitiveEntry(Expressions.singleAssignedNonNameValue((Name)expression).orElse(null));
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            return JwtVerificationCheck.hasTrueVerifySignatureEntry((DictionaryLiteral)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL})) {
            return JwtVerificationCheck.hasTrueVerifySignatureEntry((ListLiteral)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            return JwtVerificationCheck.isCallToDict((CallExpression)expression) && JwtVerificationCheck.hasIllegalDictKWArgument((CallExpression)expression);
        }
        return false;
    }

    private static boolean hasIllegalDictKWArgument(CallExpression expression) {
        return Optional.of(expression).map(CallExpression::arguments).map(arguments -> TreeUtils.argumentByKeyword((String)VERIFY_SIGNATURE_KEYWORD, (List)arguments)).map(RegularArgument::expression).filter(Expressions::isFalsy).isPresent();
    }

    private static boolean isCallToDict(CallExpression expression) {
        return Optional.of(expression).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter("dict"::equals).isPresent();
    }

    private static boolean hasTrueVerifySignatureEntry(DictionaryLiteral dictionaryLiteral) {
        return dictionaryLiteral.elements().stream().filter(KeyValuePair.class::isInstance).map(KeyValuePair.class::cast).filter(keyValuePair -> JwtVerificationCheck.isSensitiveKey(keyValuePair.key())).map(KeyValuePair::value).anyMatch(Expressions::isFalsy);
    }

    private static boolean hasTrueVerifySignatureEntry(ListLiteral listLiteral) {
        return listLiteral.elements().expressions().stream().filter(Tuple.class::isInstance).map(Tuple.class::cast).map(Tuple::elements).filter(list -> list.size() == 2).filter(list -> JwtVerificationCheck.isSensitiveKey((Expression)list.get(0))).map(list -> (Expression)list.get(1)).anyMatch(Expressions::isFalsy);
    }

    private static boolean isSensitiveKey(Expression key) {
        return key.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && VERIFY_SIGNATURE_KEYWORD.equals(((StringLiteral)key).trimmedQuotesValue());
    }

    private static boolean isCallToVerifyJwt(Tree t) {
        return TreeUtils.toOptionalInstanceOf(CallExpression.class, (Tree)t).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter(VERIFY_JWT_FQNS::contains).isPresent();
    }
}

