/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.InExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5642")
public class MembershipTestSupportCheck
extends PythonSubscriptionCheck {
    private static final String PRIMARY_MESSAGE = "Change the type of %s";
    private static final String PRIMARY_MESSAGE_MULTILINE = "Change the type for the target expression of `in`";
    private static final String KNOWN_TYPE_MESSAGE = "; type %s does not support membership protocol.";
    private static final String UNKNOWN_TYPE_MESSAGE = "; the type does not support the membership protocol.";
    private static final String SECONDARY_MESSAGE = "The result value of this expression does not support the membership protocol.";
    private static final List<String> MEMBERSHIP_PROTOCOL_ENABLING_METHODS = List.of("__contains__", "__iter__", "__getitem__");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IN, ctx -> MembershipTestSupportCheck.checkInExpression(ctx, (InExpression)ctx.syntaxNode()));
    }

    private static void checkInExpression(SubscriptionContext ctx, InExpression inExpression) {
        Expression rhs = inExpression.rightOperand();
        InferredType rhsType = rhs.type();
        if (MembershipTestSupportCheck.canSupportMembershipProtocol(rhsType)) {
            return;
        }
        MembershipTestSupportCheck.addIssueOnInAndNotIn(ctx, inExpression, MembershipTestSupportCheck.genPrimaryMessage(rhs, rhsType)).secondary((Tree)inExpression.rightOperand(), SECONDARY_MESSAGE);
    }

    private static String genPrimaryMessage(Expression rhs, InferredType rhsType) {
        String inTarget = TreeUtils.treeToString((Tree)rhs, (boolean)false);
        Object message = inTarget == null ? PRIMARY_MESSAGE_MULTILINE : String.format(PRIMARY_MESSAGE, inTarget);
        String typeName = InferredTypes.typeName((InferredType)rhsType);
        message = typeName != null ? (String)message + String.format(KNOWN_TYPE_MESSAGE, typeName) : (String)message + UNKNOWN_TYPE_MESSAGE;
        return message;
    }

    private static PythonCheck.PreciseIssue addIssueOnInAndNotIn(SubscriptionContext ctx, InExpression inExpression, String message) {
        Token notToken = inExpression.notToken();
        if (notToken == null) {
            return ctx.addIssue(inExpression.operator(), message);
        }
        return ctx.addIssue(notToken, inExpression.operator(), message);
    }

    private static boolean canSupportMembershipProtocol(InferredType type) {
        for (String methodName : MEMBERSHIP_PROTOCOL_ENABLING_METHODS) {
            switch (MembershipTestSupportCheck.canMemberBeMethod(type, methodName)) {
                case NOT_A_METHOD: {
                    return false;
                }
                case METHOD: 
                case UNKNOWN: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canBeMethodSymbol(Symbol symbol) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return true;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.OTHER})) {
            List<Usage> bindingUsages = symbol.usages().stream().filter(Usage::isBindingUsage).limit(2L).toList();
            if (bindingUsages.size() == 1) {
                Usage bindingUsage = bindingUsages.get(0);
                Tree assignment = TreeUtils.firstAncestorOfKind((Tree)bindingUsage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
                return assignment == null || ((AssignmentStatement)assignment).assignedValue().type().canHaveMember("__call__");
            }
            return true;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.AMBIGUOUS})) {
            return ((AmbiguousSymbol)symbol).alternatives().stream().anyMatch(MembershipTestSupportCheck::canBeMethodSymbol);
        }
        return false;
    }

    private static MemberType canMemberBeMethod(InferredType type, String methodName) {
        Optional maybeMember = type.resolveMember(methodName);
        if (maybeMember.isPresent()) {
            Symbol symbol = (Symbol)maybeMember.get();
            if (MembershipTestSupportCheck.canBeMethodSymbol(symbol)) {
                return MemberType.METHOD;
            }
            return MemberType.NOT_A_METHOD;
        }
        if (!type.canHaveMember(methodName)) {
            return MemberType.NOT_PRESENT;
        }
        return MemberType.UNKNOWN;
    }

    private static enum MemberType {
        METHOD,
        NOT_A_METHOD,
        NOT_PRESENT,
        UNKNOWN;

    }
}

