/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1066")
public class CollapsibleIfStatementsCheck
extends PythonVisitorCheck {
    public static final String CHECK_KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";
    private static final int MAX_LINE_LENGTH = 80;
    private static final int AND_LENGTH = 5;
    private Set<Tree> ignored = new HashSet<Tree>();

    public void scanFile(PythonVisitorContext visitorContext) {
        this.ignored.clear();
        super.scanFile(visitorContext);
    }

    public void visitIfStatement(IfStatement ifStatement) {
        List statements = ifStatement.body().statements();
        if (!ifStatement.elifBranches().isEmpty()) {
            if (ifStatement.elseBranch() == null) {
                this.ignored.addAll(ifStatement.elifBranches().subList(0, ifStatement.elifBranches().size() - 1));
            } else {
                this.ignored.addAll(ifStatement.elifBranches());
            }
        }
        if (!this.ignored.contains(ifStatement) && ifStatement.elseBranch() == null && ifStatement.elifBranches().isEmpty() && statements.size() == 1 && ((Statement)statements.get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STMT})) {
            IfStatement singleIfChild = (IfStatement)statements.get(0);
            if (CollapsibleIfStatementsCheck.isException(singleIfChild, ifStatement)) {
                return;
            }
            this.addIssue(singleIfChild.keyword(), MESSAGE).secondary(ifStatement.keyword(), "enclosing");
        }
        super.visitIfStatement(ifStatement);
    }

    private static boolean isException(IfStatement singleIfChild, IfStatement enclosingIfStatement) {
        return singleIfChild.isElif() || singleIfChild.elseBranch() != null || !singleIfChild.elifBranches().isEmpty() || CollapsibleIfStatementsCheck.wouldCauseLongLineLength(singleIfChild, enclosingIfStatement) || singleIfChild.condition().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_EXPRESSION}) || enclosingIfStatement.condition().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_EXPRESSION}) || CollapsibleIfStatementsCheck.hasCommentsBetweenEnclosingAndChildIf(singleIfChild, enclosingIfStatement);
    }

    private static boolean hasCommentsBetweenEnclosingAndChildIf(IfStatement singleIfChild, IfStatement enclosingIfStatement) {
        return TreeUtils.tokens((Tree)enclosingIfStatement).stream().anyMatch(token -> !token.trivia().isEmpty() && ((Trivia)token.trivia().get(0)).token().line() < singleIfChild.firstToken().line());
    }

    private static boolean wouldCauseLongLineLength(IfStatement singleIfChild, IfStatement enclosingIf) {
        int childConditionLength = CollapsibleIfStatementsCheck.lastColumn(singleIfChild) - singleIfChild.condition().firstToken().column();
        return CollapsibleIfStatementsCheck.lastColumn(enclosingIf) + childConditionLength + 5 > 80;
    }

    private static int lastColumn(IfStatement ifStatement) {
        Token lastToken = ifStatement.condition().lastToken();
        return lastToken.column() + lastToken.value().length();
    }
}

