/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.PythonType;
import org.sonar.python.types.v2.TriBool;

@Rule(key="S5756")
public class NonCallableCalledCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Expression callee = callExpression.callee();
            PythonType type = callee.typeV2();
            if (this.isNonCallableType(type)) {
                String name = TreeUtils.nameFromExpression((Expression)callee);
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)callee, this.message(type, name));
                type.definitionLocation().ifPresent(location -> preciseIssue.secondary(location, "Definition."));
            }
        });
    }

    protected static String addTypeName(PythonType type) {
        return type.displayName().map(d -> " has type " + d + " and it").orElse("");
    }

    public boolean isNonCallableType(PythonType type) {
        return type.hasMember("__call__") == TriBool.FALSE;
    }

    public String message(PythonType typeV2, @Nullable String name) {
        if (name != null) {
            return "Fix this call; \"%s\"%s is not callable.".formatted(name, NonCallableCalledCheck.addTypeName(typeV2));
        }
        return "Fix this call; this expression%s is not callable.".formatted(NonCallableCalledCheck.addTypeName(typeV2));
    }
}

