/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6918")
public class NonSingletonTfVariableCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, NonSingletonTfVariableCheck::checkCallExpression);
    }

    private static void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol == null || !"tensorflow.Variable".equals(symbol.fullyQualifiedName())) {
            return;
        }
        if (!NonSingletonTfVariableCheck.isWithinTensorflowFunction((Tree)callExpression)) {
            return;
        }
        if (NonSingletonTfVariableCheck.isUnconditional(callExpression)) {
            ctx.addIssue((Tree)callExpression, "Refactor this variable declaration to be a singleton.");
        }
    }

    private static boolean isUnconditional(CallExpression callExpression) {
        Tree firstAncestor = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.IF_STMT, Tree.Kind.CONDITIONAL_EXPR});
        return firstAncestor != null && firstAncestor.is(new Tree.Kind[]{Tree.Kind.FUNCDEF});
    }

    private static boolean isWithinTensorflowFunction(Tree tree) {
        return TreeUtils.firstAncestor((Tree)tree, t -> TreeUtils.isFunctionWithGivenDecoratorFQN((Tree)t, (String)"tensorflow.function")) != null;
    }
}

