/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6929")
public class TfSpecifyReductionAxisCheck
extends PythonSubscriptionCheck {
    private static final Set<String> REDUCTION_FUNCTIONS = new HashSet<String>(Arrays.asList("reduce_all", "reduce_mean", "reduce_any", "reduce_euclidean_norm", "reduce_logsumexp", "reduce_max", "reduce_min", "reduce_prod", "reduce_std", "reduce_sum", "reduce_variance"));
    private static final Set<String> REDUCTION_FUNCTIONS_FQN = new HashSet<String>();
    private static final String MESSAGE = "Provide a value for the axis argument.";
    public static final String AXIS_PARAMETER = "axis";
    public static final int AXIS_PARAMETER_POSITION = 1;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, TfSpecifyReductionAxisCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol == null || !REDUCTION_FUNCTIONS_FQN.contains(symbol.fullyQualifiedName()) || TreeUtils.nthArgumentOrKeyword((int)1, (String)AXIS_PARAMETER, (List)callExpression.arguments()) != null) {
            return;
        }
        context.addIssue((Tree)callExpression.callee(), MESSAGE);
    }

    static {
        for (String reductionFunction : REDUCTION_FUNCTIONS) {
            REDUCTION_FUNCTIONS_FQN.add("tensorflow.math." + reductionFunction);
            REDUCTION_FUNCTIONS_FQN.add("tensorflow.tf." + reductionFunction);
        }
    }
}

