/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.FunctionDefImpl;

@Rule(key="S6538")
public class MandatoryFunctionReturnTypeHintCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a return type hint to this function declaration.";
    private static final String CONSTRUCTOR_MESSAGE = "Annotate the return type of this constructor with `None`.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (functionDef.returnTypeAnnotation() == null) {
                Name functionName = functionDef.name();
                FunctionDefImpl functionDefImpl = (FunctionDefImpl)functionDef;
                Optional.ofNullable(functionDefImpl.functionSymbol()).filter(functionSymbol -> "__init__".equals(functionName.name()) && functionSymbol.isInstanceMethod()).ifPresentOrElse(symbol -> ctx.addIssue((Tree)functionName, CONSTRUCTOR_MESSAGE), () -> ctx.addIssue((Tree)functionName, MESSAGE));
            }
        });
    }
}

