/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.ReprExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="BackticksUsage")
public class BackticksUsageCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.REPR, ctx -> {
            ReprExpression node = (ReprExpression)ctx.syntaxNode();
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)node, "Use \"repr\" instead.");
            PythonTextEdit text1 = TextEditUtils.replace((Tree)node.openingBacktick(), (String)"repr(");
            PythonTextEdit text2 = TextEditUtils.replace((Tree)node.closingBacktick(), (String)")");
            PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)"Replace backtick with \"repr()\".").addTextEdit(new PythonTextEdit[]{text1}).addTextEdit(new PythonTextEdit[]{text2}).build();
            issue.addQuickFix(quickFix);
        });
    }
}

