/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.checks.utils.DeadStoreUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.checks.utils.ImportedNamesCollector;
import org.sonar.python.checks.utils.StringLiteralValuesCollector;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1854")
public class DeadStoreCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TEMPLATE = "Remove this assignment to local variable '%s'; the value is never used.";
    private static final String SECONDARY_MESSAGE_TEMPLATE = "'%s' is reassigned here.";
    public static final String QUICK_FIX_MESSAGE = "Remove the unused assignment";
    private boolean isTemplateVariablesAccessEnabled = false;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::checkTemplateVariablesAccessEnabled);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.hasDescendant((Tree)functionDef, tree -> tree.is(new Tree.Kind[]{Tree.Kind.TRY_STMT}))) {
                return;
            }
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            LiveVariablesAnalysis lva = LiveVariablesAnalysis.analyze((ControlFlowGraph)cfg);
            cfg.blocks().forEach(block -> this.verifyBlock((SubscriptionContext)ctx, (CfgBlock)block, lva.getLiveVariables(block), lva.getReadSymbols(), functionDef));
        });
    }

    private void checkTemplateVariablesAccessEnabled(SubscriptionContext ctx) {
        ImportedNamesCollector importedNamesCollector = new ImportedNamesCollector();
        importedNamesCollector.collect(ctx.syntaxNode());
        this.isTemplateVariablesAccessEnabled = importedNamesCollector.anyMatches("pandas"::equals);
    }

    private void verifyBlock(SubscriptionContext ctx, CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, Set<Symbol> readSymbols, FunctionDef functionDef) {
        StringLiteralValuesCollector stringLiteralValuesCollector = new StringLiteralValuesCollector();
        if (this.isTemplateVariablesAccessEnabled) {
            stringLiteralValuesCollector.collect((Tree)functionDef);
        }
        DeadStoreUtils.findUnnecessaryAssignments(block, blockLiveVariables, functionDef).stream().filter(unnecessaryAssignment -> readSymbols.contains(unnecessaryAssignment.symbol)).filter(unnecessaryAssignment -> !DeadStoreCheck.isException(unnecessaryAssignment.symbol, unnecessaryAssignment.element, functionDef, stringLiteralValuesCollector)).forEach(unnecessaryAssignment -> DeadStoreCheck.raiseIssue(ctx, unnecessaryAssignment));
    }

    private static void raiseIssue(SubscriptionContext ctx, DeadStoreUtils.UnnecessaryAssignment unnecessaryAssignment) {
        Statement statement;
        Tree element = unnecessaryAssignment.element;
        String symbolName = unnecessaryAssignment.symbol.name();
        String message = String.format(MESSAGE_TEMPLATE, symbolName);
        Token lastRelevantToken = TreeUtils.getTreeSeparatorOrLastToken((Tree)element);
        PythonCheck.PreciseIssue issue = "\n".equals(lastRelevantToken.value()) ? ctx.addIssue(element, message) : ctx.addIssue(element.firstToken(), lastRelevantToken, message);
        ((Map)unnecessaryAssignment.symbol.usages().stream().filter(Usage::isBindingUsage).map(Usage::tree).filter(tree -> tree != element && TreeUtils.firstAncestor((Tree)tree, parent -> parent == element) == null).filter(tree -> TreeUtils.getTreeByPositionComparator().compare(tree, element) > 0).collect(TreeUtils.groupAssignmentByParentStatementList())).values().stream().sorted(TreeUtils.getTreeByPositionComparator()).map(DeadStoreCheck::mapToParentAssignmentStatementOrExpression).forEach(tree -> issue.secondary(tree, String.format(SECONDARY_MESSAGE_TEMPLATE, symbolName)));
        if (element instanceof Statement && !DeadStoreCheck.isExceptionForQuickFix(statement = (Statement)element)) {
            if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)element).lhsExpressions().size() > 1) {
                DeadStoreCheck.addMultipleAssignmentStatementQuickFix((AssignmentStatement)element, issue, unnecessaryAssignment.symbol);
            } else {
                issue.addQuickFix(PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.removeStatement((Statement)statement)}));
            }
        }
    }

    private static void addMultipleAssignmentStatementQuickFix(AssignmentStatement element, PythonCheck.PreciseIssue issue, Symbol symbol) {
        List children = element.children();
        IntStream.range(0, children.size()).filter(i -> DeadStoreCheck.isExpressionHasSymbol((Tree)children.get(i), symbol)).findFirst().ifPresent(i -> {
            int from = i == 0 ? i : i - 1;
            int to = from + 2;
            issue.addQuickFix(PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.removeUntil((Tree)((Tree)children.get(from)), (Tree)((Tree)children.get(to)))}));
        });
    }

    private static boolean isExpressionHasSymbol(Tree element, Symbol symbol) {
        return element.children().stream().filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).anyMatch(s -> s == symbol);
    }

    private static Tree mapToParentAssignmentStatementOrExpression(Tree tree) {
        Tree assignment = TreeUtils.firstAncestor((Tree)tree, parent -> parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ASSIGNMENT_EXPRESSION}));
        if (assignment != null) {
            return assignment;
        }
        return tree;
    }

    private static boolean isMultipleAssignement(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)element).lhsExpressions().stream().anyMatch(lhsExpression -> lhsExpression.expressions().size() > 1);
    }

    private static boolean isException(Symbol symbol, Tree element, FunctionDef functionDef, StringLiteralValuesCollector stringLiteralValuesCollector) {
        return DeadStoreCheck.isUnderscoreVariable(symbol) || DeadStoreCheck.isAssignmentToFalsyOrTrueLiteral(element) || DeadStoreCheck.isFunctionDeclarationSymbol(symbol) || DeadStoreCheck.isLoopDeclarationSymbol(symbol, element) || DeadStoreCheck.isWithInstance(element) || DeadStoreUtils.isUsedInSubFunction(symbol, functionDef) || DeadStoreUtils.isParameter(element) || DeadStoreCheck.isMultipleAssignement(element) || DeadStoreCheck.isAnnotatedAssignmentWithoutRhs(element) || DeadStoreCheck.isVariableAccessedInStringTemplate(symbol, stringLiteralValuesCollector);
    }

    private static boolean isVariableAccessedInStringTemplate(Symbol symbol, StringLiteralValuesCollector stringLiteralsCollector) {
        return stringLiteralsCollector.anyMatches(s -> s.matches(".*@" + symbol.name() + "((\\s+.*)|$)"));
    }

    private static boolean isAnnotatedAssignmentWithoutRhs(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT}) && ((AnnotatedAssignment)element).assignedValue() == null;
    }

    private static boolean isUnderscoreVariable(Symbol symbol) {
        return symbol.name().equals("_");
    }

    private static boolean isLoopDeclarationSymbol(Symbol symbol, Tree element) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.LOOP_DECLARATION) && TreeUtils.firstAncestorOfKind((Tree)element, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FOR_STMT}) != null;
    }

    private static boolean isWithInstance(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.WITH_ITEM});
    }

    private static boolean isAssignmentToFalsyOrTrueLiteral(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT})) {
            Expression assignedValue = element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) ? ((AssignmentStatement)element).assignedValue() : ((AnnotatedAssignment)element).assignedValue();
            return assignedValue != null && (Expressions.isFalsy(assignedValue) || assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME}) && "True".equals(((Name)assignedValue).name()) || DeadStoreCheck.isNumericLiteralOne(assignedValue) || DeadStoreCheck.isMinusOne(assignedValue));
        }
        return false;
    }

    private static boolean isMinusOne(Expression assignedValue) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
            Expression expression = ((UnaryExpression)assignedValue).expression();
            return DeadStoreCheck.isNumericLiteralOne(expression);
        }
        return false;
    }

    private static boolean isNumericLiteralOne(Expression expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((NumericLiteral)expression).valueAsString());
    }

    private static boolean isFunctionDeclarationSymbol(Symbol symbol) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.FUNC_DECLARATION);
    }

    private static boolean isExceptionForQuickFix(Statement tree) {
        switch (tree.getKind()) {
            case ANNOTATED_ASSIGNMENT: {
                return SideEffectDetector.hasSideEffect(((AnnotatedAssignment)tree).assignedValue());
            }
            case ASSIGNMENT_STMT: {
                return SideEffectDetector.hasSideEffect(((AssignmentStatement)tree).assignedValue());
            }
            case EXPRESSION_STMT: {
                ExpressionStatement expressionStatement = (ExpressionStatement)tree;
                return expressionStatement.expressions().stream().anyMatch(SideEffectDetector::hasSideEffect);
            }
        }
        return false;
    }

    private static class SideEffectDetector
    extends BaseTreeVisitor {
        private boolean sideEffect = false;

        private SideEffectDetector() {
        }

        public static boolean hasSideEffect(@Nullable Expression expression) {
            if (expression == null) {
                return false;
            }
            SideEffectDetector detector = new SideEffectDetector();
            detector.scan((Tree)expression);
            return detector.sideEffect;
        }

        public void visitCallExpression(CallExpression callExpression) {
            this.sideEffect = true;
        }
    }
}

