/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FormatSpecifier;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6799")
public class FStringNestingLevelCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Do not nest f-strings too deeply.";
    private static final Set<StringElement> visited = new HashSet<StringElement>();
    private static final int MAX_DEPTH = 3;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> visited.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, FStringNestingLevelCheck::checkNestingDepthOfFString);
    }

    private static void checkNestingDepthOfFString(SubscriptionContext ctx) {
        if (!FStringNestingLevelCheck.supportsTypeParameterSyntax(ctx)) {
            return;
        }
        StringElement element = (StringElement)ctx.syntaxNode();
        if (FStringNestingLevelCheck.isFStringNestedTooDeep(element, 0)) {
            ctx.addIssue((Tree)element, MESSAGE);
        }
    }

    private static boolean isFStringNestedTooDeep(StringElement element, int count) {
        if (!visited.contains(element) && element.isInterpolated()) {
            visited.add(element);
            int updatedCount = count + 1;
            if (updatedCount >= 3) {
                return true;
            }
            return FStringNestingLevelCheck.areFormattedExpressionsNestedTooDeep(element.formattedExpressions(), updatedCount);
        }
        return false;
    }

    private static boolean areFormattedExpressionsNestedTooDeep(List<FormattedExpression> formattedExpressions, int updatedCount) {
        for (FormattedExpression formattedExpression : formattedExpressions) {
            if (!FStringNestingLevelCheck.isTheNestingTooDeepInExpression(formattedExpression.expression(), updatedCount) && !FStringNestingLevelCheck.isTheNestingTooDeepInFormatSpecifier(formattedExpression.formatSpecifier(), updatedCount)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTheNestingTooDeepInExpression(Expression expression, int updatedCount) {
        return Optional.of(expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).map(StringLiteral::stringElements).map(Collection::stream).map(elements -> elements.anyMatch(sElement -> FStringNestingLevelCheck.isFStringNestedTooDeep(sElement, updatedCount))).orElse(false);
    }

    private static boolean isTheNestingTooDeepInFormatSpecifier(@Nullable FormatSpecifier formatSpecifier, int updatedCount) {
        return Optional.ofNullable(formatSpecifier).map(FormatSpecifier::formatExpressions).map(formattedExpressions -> FStringNestingLevelCheck.areFormattedExpressionsNestedTooDeep(formattedExpressions, updatedCount)).orElse(false);
    }

    private static boolean supportsTypeParameterSyntax(SubscriptionContext ctx) {
        PythonVersionUtils.Version required = PythonVersionUtils.Version.V_312;
        return ctx.sourcePythonVersions().stream().allMatch(version -> version.compare(required.major(), required.minor()) >= 0);
    }
}

