/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S6792")
public class GenericClassTypeParameterCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use the \"type\" parameter syntax to declare this generic class.";
    private static final String SECONDARY_MESSAGE_PARENT = "\"Generic\" parent.";
    private static final String SECONDARY_MESSAGE_ASSIGNMENT = "\"Generic\" is assigned here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, GenericClassTypeParameterCheck::checkGenericInheritance);
    }

    private static void checkGenericInheritance(SubscriptionContext ctx) {
        if (!GenericClassTypeParameterCheck.supportsTypeParameterSyntax(ctx)) {
            return;
        }
        ClassDef classDef = (ClassDef)ctx.syntaxNode();
        Optional.of(classDef).map(ClassDef::args).map(ArgList::arguments).stream().flatMap(Collection::stream).map(GenericClassTypeParameterCheck::checkGenericValue).filter(lst -> !lst.isEmpty()).findFirst().ifPresent(locations -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)classDef.name(), MESSAGE);
            locations.forEach(arg_0 -> ((PythonCheck.PreciseIssue)issue).secondary(arg_0));
        });
    }

    private static List<IssueLocation> checkGenericValue(Argument argument) {
        Name name;
        Expression assignedValue;
        if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            return Collections.emptyList();
        }
        Expression expression = ((RegularArgument)argument).expression();
        if (GenericClassTypeParameterCheck.isTypingGeneric(expression)) {
            return List.of(IssueLocation.preciseLocation((Tree)argument, (String)SECONDARY_MESSAGE_PARENT));
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && (assignedValue = Expressions.singleAssignedValue(name = (Name)expression)) != null && GenericClassTypeParameterCheck.isTypingGeneric(assignedValue)) {
            return List.of(IssueLocation.preciseLocation((Tree)argument, (String)SECONDARY_MESSAGE_PARENT), IssueLocation.preciseLocation((Tree)assignedValue, (String)SECONDARY_MESSAGE_ASSIGNMENT));
        }
        return Collections.emptyList();
    }

    private static boolean isTypingGeneric(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            expression = ((SubscriptionExpression)expression).object();
        }
        return Optional.of(expression).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter("typing.Generic"::equals).isPresent();
    }

    private static boolean supportsTypeParameterSyntax(SubscriptionContext ctx) {
        PythonVersionUtils.Version required = PythonVersionUtils.Version.V_312;
        return ctx.sourcePythonVersions().stream().allMatch(version -> version.compare(required.major(), required.minor()) >= 0);
    }
}

