/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.IncompatibleOperands;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5607")
public class IncompatibleOperandsCheck
extends IncompatibleOperands {
    @Override
    public IncompatibleOperands.SpecialMethod resolveMethod(InferredType type, String method) {
        Symbol resolvedMethod = type.resolveMember(method).orElse(null);
        boolean isUnresolved = resolvedMethod == null && type.canHaveMember(method);
        return new IncompatibleOperands.SpecialMethod(resolvedMethod, isUnresolved);
    }

    @Override
    public String message(Token operator, InferredType left, InferredType right) {
        String leftTypeName = InferredTypes.typeName((InferredType)left);
        String rightTypeName = InferredTypes.typeName((InferredType)right);
        String message = "Fix this invalid \"" + operator.value() + "\" operation between incompatible types";
        if (leftTypeName != null && rightTypeName != null) {
            message = message + " (" + leftTypeName + " and " + rightTypeName + ")";
        }
        return message + ".";
    }

    @Override
    public String message(Token operator) {
        return "Fix this invalid \"" + operator.value() + "\" operation on a type which doesn't support it.";
    }
}

