/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ItemOperationsType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5644")
public class ItemOperationsTypeCheck
extends ItemOperationsType {
    @Override
    public boolean isValidSubscription(Expression subscriptionObject, String requiredMethod, @Nullable String classRequiredMethod, Map<LocationInFile, String> secondaries) {
        InferredType type;
        String typeName;
        Symbol subscriptionCalleeSymbol;
        if (subscriptionObject.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
            return false;
        }
        if (subscriptionObject.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && (subscriptionCalleeSymbol = ((CallExpression)subscriptionObject).calleeSymbol()) != null && subscriptionCalleeSymbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) && ((FunctionSymbol)subscriptionCalleeSymbol).isAsynchronous()) {
            FunctionSymbol functionSymbol = (FunctionSymbol)subscriptionCalleeSymbol;
            secondaries.put(functionSymbol.definitionLocation(), String.format("Definition of \"%s\".", functionSymbol.name()));
            return false;
        }
        if (subscriptionObject instanceof HasSymbol) {
            HasSymbol hasSymbol = (HasSymbol)subscriptionObject;
            Symbol symbol = hasSymbol.symbol();
            if (symbol == null || ItemOperationsTypeCheck.isTypingOrCollectionsSymbol(symbol)) {
                return true;
            }
            if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION, Symbol.Kind.CLASS})) {
                secondaries.put(symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) ? ((FunctionSymbol)symbol).definitionLocation() : ((ClassSymbol)symbol).definitionLocation(), String.format("Definition of \"%s\".", symbol.name()));
                return ItemOperationsTypeCheck.canHaveMethod(symbol, requiredMethod, classRequiredMethod);
            }
        }
        String secondaryMessage = (typeName = InferredTypes.typeName((InferredType)(type = subscriptionObject.type()))) != null ? String.format("Definition of \"%s\".", typeName) : "Type definition.";
        secondaries.put(InferredTypes.typeClassLocation((InferredType)type), secondaryMessage);
        return type.canHaveMember(requiredMethod);
    }

    @Override
    public String message(@Nullable String name, String missingMethod) {
        if (name != null) {
            return String.format("Fix this code; \"%s\" does not have a \"%s\" method.", name, missingMethod);
        }
        return String.format("Fix this code; this expression does not have a \"%s\" method.", missingMethod);
    }

    private static boolean isTypingOrCollectionsSymbol(Symbol symbol) {
        String fullyQualifiedName = symbol.fullyQualifiedName();
        return fullyQualifiedName != null && (fullyQualifiedName.startsWith("typing") || fullyQualifiedName.startsWith("collections"));
    }

    private static boolean canHaveMethod(Symbol symbol, String requiredMethod, @Nullable String classRequiredMethod) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ((FunctionSymbol)symbol).hasDecorators();
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.canHaveMember(requiredMethod) || classRequiredMethod != null && classSymbol.canHaveMember(classRequiredMethod) || classSymbol.hasDecorators();
    }
}

