/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.python.checks.NonCallableCalled;
import org.sonar.python.types.v2.PythonType;
import org.sonar.python.types.v2.TriBool;

@Rule(key="S5756")
public class NonCallableCalledCheck
extends NonCallableCalled {
    @Override
    protected boolean isExpectedTypeSource(SubscriptionContext ctx, PythonType calleeType) {
        return ctx.typeChecker().typeCheckBuilder().isExactTypeSource().check(calleeType) == TriBool.TRUE;
    }

    @Override
    protected String message(PythonType typeV2, @Nullable String name) {
        if (name != null) {
            return "Fix this call; \"%s\"%s is not callable.".formatted(name, NonCallableCalledCheck.addTypeName(typeV2));
        }
        return "Fix this call; this expression%s is not callable.".formatted(NonCallableCalledCheck.addTypeName(typeV2));
    }
}

