/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2053")
public class PredictableSaltCheck
extends PythonSubscriptionCheck {
    private static final String MISSING_SALT_MESSAGE = "Add an unpredictable salt value to this hash.";
    private static final String PREDICTABLE_SALT_MESSAGE = "Make this salt unpredictable.";
    private Map<String, Integer> sensitiveArgumentByFQN;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> this.handleCallExpression((CallExpression)ctx.syntaxNode(), (SubscriptionContext)ctx));
    }

    private void handleCallExpression(CallExpression callExpression, SubscriptionContext ctx) {
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return;
        }
        if (this.sensitiveArgumentByFQN().containsKey(calleeSymbol.fullyQualifiedName())) {
            int argNb = this.sensitiveArgumentByFQN().get(calleeSymbol.fullyQualifiedName());
            PredictableSaltCheck.checkArguments(callExpression, argNb, ctx);
        }
    }

    private static void checkArguments(CallExpression callExpression, int argNb, SubscriptionContext ctx) {
        if (callExpression.arguments().size() <= argNb) {
            ctx.addIssue((Tree)callExpression.callee(), MISSING_SALT_MESSAGE);
        }
        for (int i = 0; i < callExpression.arguments().size(); ++i) {
            Argument argument = (Argument)callExpression.arguments().get(i);
            if (!argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) continue;
            RegularArgument regularArgument = (RegularArgument)argument;
            Name keywordArgument = regularArgument.keywordArgument();
            if (keywordArgument != null) {
                if (!keywordArgument.name().equals("salt")) continue;
                PredictableSaltCheck.checkSensitiveArgument(regularArgument, ctx);
                continue;
            }
            if (i != argNb) continue;
            PredictableSaltCheck.checkSensitiveArgument(regularArgument, ctx);
        }
    }

    private static void checkSensitiveArgument(RegularArgument regularArgument, SubscriptionContext ctx) {
        if (regularArgument.expression().is(new Tree.Kind[]{Tree.Kind.NAME})) {
            Expression expression = Expressions.singleAssignedValue((Name)regularArgument.expression());
            if (expression == null) {
                return;
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                AssignmentStatement assignmentStatement = (AssignmentStatement)TreeUtils.firstAncestorOfKind((Tree)expression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
                ctx.addIssue((Tree)regularArgument, PREDICTABLE_SALT_MESSAGE).secondary((Tree)assignmentStatement, null);
            }
        }
        if (regularArgument.expression().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            ctx.addIssue((Tree)regularArgument, PREDICTABLE_SALT_MESSAGE);
        }
    }

    private Map<String, Integer> sensitiveArgumentByFQN() {
        if (this.sensitiveArgumentByFQN == null) {
            this.sensitiveArgumentByFQN = new HashMap<String, Integer>();
            this.sensitiveArgumentByFQN.put("hashlib.pbkdf2_hmac", 2);
            this.sensitiveArgumentByFQN.put("hashlib.scrypt", 4);
            this.sensitiveArgumentByFQN.put("crypt.crypt", 1);
            this.sensitiveArgumentByFQN.put("cryptography.hazmat.primitives.kdf.pbkdf2.PBKDF2HMAC", 2);
            this.sensitiveArgumentByFQN.put("Cryptodome.Protocol.KDF.PBKDF2", 1);
            this.sensitiveArgumentByFQN.put("Cryptodome.Protocol.KDF.scrypt", 1);
            this.sensitiveArgumentByFQN.put("Cryptodome.Protocol.KDF.bcrypt", 2);
            this.sensitiveArgumentByFQN = Collections.unmodifiableMap(this.sensitiveArgumentByFQN);
        }
        return this.sensitiveArgumentByFQN;
    }
}

