/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6887")
public class PytzTimeZoneInDatetimeConstructorCheck
extends PythonSubscriptionCheck {
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;
    private static final String MESSAGE = "Don't pass a \"pytz.timezone\" to the \"datetime.datetime\" constructor.";
    private static final String SECONDARY_MESSAGE = "The pytz.timezone is created here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(ctx.pythonFile());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void checkCallExpression(SubscriptionContext context) {
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol != null && "datetime.datetime".equals(calleeSymbol.fullyQualifiedName())) {
            RegularArgument argument = TreeUtils.nthArgumentOrKeyword((int)7, (String)"tzinfo", (List)callExpression.arguments());
            if (argument == null) {
                return;
            }
            this.checkArgument(argument, context);
        }
    }

    private void checkArgument(RegularArgument argument, SubscriptionContext context) {
        if (argument.expression().is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            CallExpression callExpression = (CallExpression)argument.expression();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null || !"pytz.timezone".equals(calleeSymbol.fullyQualifiedName())) {
                return;
            }
            context.addIssue((Tree)argument, MESSAGE);
        } else if (argument.expression().is(new Tree.Kind[]{Tree.Kind.NAME})) {
            List<CallExpression> allSecondaryLocations = this.reachingDefinitionsAnalysis.valuesAtLocation((Name)argument.expression()).stream().filter(expression -> expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})).map(CallExpression.class::cast).filter(call -> Optional.ofNullable(call.calleeSymbol()).map(symbol -> "pytz.timezone".equals(symbol.fullyQualifiedName())).orElse(false)).sorted(Comparator.comparingInt(call -> call.firstToken().line())).toList();
            if (allSecondaryLocations.isEmpty()) {
                return;
            }
            PythonCheck.PreciseIssue issue = context.addIssue((Tree)argument, MESSAGE);
            allSecondaryLocations.forEach(secondaryLocation -> issue.secondary((Tree)secondaryLocation, SECONDARY_MESSAGE));
        }
    }
}

