/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S6971")
public class SklearnCachedPipelineDontAccessTransformersCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Avoid accessing transformers in a cached pipeline.";
    public static final String MESSAGE_SECONDARY = "The transformer is accessed here";
    public static final String MESSAGE_SECONDARY_CREATION = "The Pipeline is created here";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, SklearnCachedPipelineDontAccessTransformersCheck::checkCallExpr);
    }

    private static void checkCallExpr(SubscriptionContext subscriptionContext) {
        CallExpression callExpression = (CallExpression)subscriptionContext.syntaxNode();
        Optional<PipelineCreation> pipelineCreationOptional = SklearnCachedPipelineDontAccessTransformersCheck.isPipelineCreation(callExpression);
        if (pipelineCreationOptional.isEmpty()) {
            return;
        }
        PipelineCreation pipelineCreation = pipelineCreationOptional.get();
        RegularArgument memoryArgument = TreeUtils.argumentByKeyword((String)"memory", (List)callExpression.arguments());
        if (memoryArgument == null || memoryArgument.expression().is(new Tree.Kind[]{Tree.Kind.NONE}) || memoryArgument.expression().type() == InferredTypes.anyType()) {
            return;
        }
        RegularArgument stepsArgument = TreeUtils.nthArgumentOrKeyword((int)0, (String)"steps", (List)callExpression.arguments());
        StepsFromPipeline stepsFromPipeline = SklearnCachedPipelineDontAccessTransformersCheck.getStepsFromPipeline(stepsArgument, pipelineCreation);
        SklearnCachedPipelineDontAccessTransformersCheck.handleStepNames(subscriptionContext, stepsFromPipeline, pipelineCreation, callExpression);
    }

    private static StepsFromPipeline getStepsFromPipeline(@Nullable RegularArgument stepsArgument, PipelineCreation pipelineCreation) {
        HashMap<Name, String> nameToStepName = new HashMap<Name, String>();
        Optional<Expression> stepArgumentExpression = Optional.ofNullable(stepsArgument).map(RegularArgument::expression);
        Stream<Name> stepNames = stepArgumentExpression.map(e -> pipelineCreation == PipelineCreation.PIPELINE ? SklearnCachedPipelineDontAccessTransformersCheck.extractFromPipeline(e, nameToStepName) : SklearnCachedPipelineDontAccessTransformersCheck.extractFromMakePipeline(e)).orElse(Stream.empty());
        return new StepsFromPipeline(nameToStepName, stepNames);
    }

    private static void handleStepNames(SubscriptionContext subscriptionContext, StepsFromPipeline stepsFromPipeline, PipelineCreation pipelineCreation, CallExpression callExpression) {
        stepsFromPipeline.stepNames().map(name -> Map.entry(name, SklearnCachedPipelineDontAccessTransformersCheck.symbolIsUsedInQualifiedExpression(name))).forEach(entry -> {
            Name name = (Name)entry.getKey();
            Map uses = (Map)entry.getValue();
            if (!uses.isEmpty()) {
                SklearnCachedPipelineDontAccessTransformersCheck.createIssue(subscriptionContext, stepsFromPipeline, pipelineCreation, callExpression, name, uses);
            }
        });
    }

    private static void createIssue(SubscriptionContext subscriptionContext, StepsFromPipeline stepsFromPipeline, PipelineCreation pipelineCreation, CallExpression callExpression, Name name, Map<Tree, QualifiedExpression> uses) {
        PythonCheck.PreciseIssue issue = subscriptionContext.addIssue((Tree)name, MESSAGE);
        uses.forEach((useTree, qualExpr) -> issue.secondary(useTree, MESSAGE_SECONDARY));
        if (pipelineCreation == PipelineCreation.PIPELINE) {
            issue.secondary((Tree)callExpression.callee(), MESSAGE_SECONDARY_CREATION);
            uses.forEach((useTree, qualExpr) -> Expressions.getAssignedName((Expression)callExpression).flatMap(pipelineBindingVariable -> SklearnCachedPipelineDontAccessTransformersCheck.getQuickFix(pipelineBindingVariable, (Tree)name, qualExpr, stepsFromPipeline.nameToStepName())).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0)));
        }
    }

    private static Stream<Name> extractFromMakePipeline(Expression stepArgumentExpression) {
        return Optional.of(stepArgumentExpression).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.NAME})).map(Name.class::cast).stream();
    }

    private static Stream<Name> extractFromPipeline(Expression stepArgumentExpression, Map<Name, String> nameToStepName) {
        return Optional.of(stepArgumentExpression).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL})).map(e -> ((ListLiteral)e).elements().expressions()).stream().flatMap(Collection::stream).filter(e -> e.is(new Tree.Kind[]{Tree.Kind.TUPLE})).map(t -> ((TupleImpl)t).elements()).filter(e -> e.size() == 2).filter(e -> ((Expression)e.get(1)).is(new Tree.Kind[]{Tree.Kind.NAME})).map(elements -> {
            if (((Expression)elements.get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
                nameToStepName.put((Name)elements.get(1), ((StringLiteral)elements.get(0)).trimmedQuotesValue());
            }
            return elements;
        }).map(e -> (Expression)e.get(1)).map(Name.class::cast);
    }

    private static Optional<PythonQuickFix> getQuickFix(Name pipelineBindingVariable, Tree name, QualifiedExpression qualifiedExpression, Map<Name, String> nameToStepName) {
        return Optional.ofNullable(nameToStepName.get(name)).map(stepName -> PythonQuickFix.newQuickFix((String)"Access the property through the ").addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)qualifiedExpression.qualifier(), (String)String.format("%s.named_steps[\"%s\"]", pipelineBindingVariable.name(), stepName))}).build());
    }

    private static Map<Tree, QualifiedExpression> symbolIsUsedInQualifiedExpression(Name name) {
        Symbol symbol = name.symbol();
        if (symbol == null) {
            return new HashMap<Tree, QualifiedExpression>();
        }
        HashMap<Tree, QualifiedExpression> qualifiedExpressions = new HashMap<Tree, QualifiedExpression>();
        symbol.usages().stream().filter(u -> u.tree().parent().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})).forEach(u -> qualifiedExpressions.put((Tree)((QualifiedExpression)u.tree().parent()).qualifier(), (QualifiedExpression)u.tree().parent()));
        return qualifiedExpressions;
    }

    private static Optional<PipelineCreation> isPipelineCreation(CallExpression callExpression) {
        return Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).map(fqn -> {
            if ("sklearn.pipeline.Pipeline".equals(fqn)) {
                return PipelineCreation.PIPELINE;
            }
            if ("sklearn.pipeline.make_pipeline".equals(fqn)) {
                return PipelineCreation.MAKE_PIPELINE;
            }
            return null;
        });
    }

    private static enum PipelineCreation {
        PIPELINE,
        MAKE_PIPELINE;

    }

    private record StepsFromPipeline(Map<Name, String> nameToStepName, Stream<Name> stepNames) {
    }
}

