/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6969")
public class SklearnPipelineSpecifyMemoryArgumentCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Specify a memory argument for the pipeline.";
    public static final String MESSAGE_QUICKFIX = "Add the memory argument";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, SklearnPipelineSpecifyMemoryArgumentCheck::checkCallExpression);
    }

    private static void checkCallExpression(SubscriptionContext subscriptionContext) {
        Optional.of(subscriptionContext.syntaxNode()).map(CallExpression.class::cast).filter(SklearnPipelineSpecifyMemoryArgumentCheck::isPipelineCreation).ifPresent(callExpression -> {
            RegularArgument memoryArgument = TreeUtils.argumentByKeyword((String)"memory", (List)callExpression.arguments());
            if (memoryArgument != null) {
                return;
            }
            if (Expressions.getAssignedName((Expression)callExpression).map(SklearnPipelineSpecifyMemoryArgumentCheck::isUsedInAnotherPipeline).orElse(false).booleanValue()) {
                return;
            }
            SklearnPipelineSpecifyMemoryArgumentCheck.createIssue(subscriptionContext, callExpression);
        });
    }

    private static void createIssue(SubscriptionContext subscriptionContext, CallExpression callExpression) {
        PythonCheck.PreciseIssue issue = subscriptionContext.addIssue((Tree)callExpression.callee(), MESSAGE);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)MESSAGE_QUICKFIX).addTextEdit(new PythonTextEdit[]{TextEditUtils.insertBefore((Tree)callExpression.rightPar(), (String)", memory=None")}).build();
        issue.addQuickFix(quickFix);
    }

    private static boolean isPipelineCreation(CallExpression callExpression) {
        return Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).map(fqn -> "sklearn.pipeline.Pipeline".equals(fqn) || "sklearn.pipeline.make_pipeline".equals(fqn)).orElse(false);
    }

    private static boolean isUsedInAnotherPipeline(Name name) {
        Symbol symbol = name.symbol();
        return symbol != null && symbol.usages().stream().filter(usage -> !usage.isBindingUsage()).anyMatch(u -> {
            Tree tree = u.tree();
            CallExpression callExpression = (CallExpression)TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR});
            while (callExpression != null) {
                Optional<String> fullyQualifiedName = Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName);
                if (fullyQualifiedName.isPresent() && SklearnPipelineSpecifyMemoryArgumentCheck.isPipelineCreation(callExpression)) {
                    return true;
                }
                callExpression = (CallExpression)TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR});
            }
            return false;
        });
    }
}

