/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ReturnCheckUtils;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.tree.TupleImpl;

@Rule(key="S935")
public class SpecialMethodReturnTypeCheck
extends PythonSubscriptionCheck {
    private static final Map<String, String> METHOD_TO_RETURN_TYPE = Map.of("__bool__", "bool", "__index__", "int", "__repr__", "str", "__str__", "str", "__bytes__", "bytes", "__hash__", "int", "__format__", "str", "__getnewargs__", "tuple", "__getnewargs_ex__", "tuple");
    private static final String INVALID_RETURN_TYPE_MESSAGE = "Return a value of type `%s` here.";
    private static final String INVALID_RETURN_TYPE_MESSAGE_NO_LOCATION = "Return a value of type `%s` in this method.";
    private static final String NO_RETURN_STMTS_MESSAGE = "Return a value of type `%s` in this method. Consider explicitly raising a TypeError if this class is not meant to support this method.";
    private static final String COROUTINE_METHOD_MESSAGE = "Return a value of type `%s` in this method. The method can not be a coroutine and have the `async` keyword.";
    private static final String GENERATOR_METHOD_MESSAGE = "Return a value of type `%s` in this method. The method can not be a generator and contain `yield` expressions.";
    private static final String INVALID_GETNEWARGSEX_TUPLE_MESSAGE = String.format("Return a value of type `%s` here.", "tuple[tuple, dict]");
    private static final String INVALID_GETNEWARGSEX_ELEMENT_COUNT_MESSAGE = INVALID_GETNEWARGSEX_TUPLE_MESSAGE + " A tuple of two elements was expected but found tuple with %d element(s).";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> SpecialMethodReturnTypeCheck.checkClassDefinition(ctx, (ClassDef)ctx.syntaxNode()));
    }

    private static void checkClassDefinition(SubscriptionContext ctx, ClassDef classDef) {
        for (FunctionDef methodDef : TreeUtils.topLevelFunctionDefs((ClassDef)classDef)) {
            SpecialMethodReturnTypeCheck.checkFunctionDefinition(ctx, methodDef, CheckUtils.mustBeAProtocolLike(classDef));
        }
    }

    private static void checkFunctionDefinition(SubscriptionContext ctx, FunctionDef funDef, boolean classIsProtocolLike) {
        String funNameString = funDef.name().name();
        String expectedReturnType = METHOD_TO_RETURN_TYPE.get(funNameString);
        if (expectedReturnType == null) {
            return;
        }
        ReturnCheckUtils.addIssueIfAsync(ctx, funDef, String.format(COROUTINE_METHOD_MESSAGE, expectedReturnType));
        ReturnCheckUtils.ReturnStmtCollector returnStmtCollector = ReturnCheckUtils.ReturnStmtCollector.collect(funDef);
        List<Token> yieldKeywords = returnStmtCollector.getYieldKeywords();
        for (Token yieldKeyword : yieldKeywords) {
            ctx.addIssue(yieldKeyword, String.format(GENERATOR_METHOD_MESSAGE, expectedReturnType));
        }
        List<ReturnStatement> returnStmts = returnStmtCollector.getReturnStmts();
        if (returnStmts.isEmpty() && yieldKeywords.isEmpty() && !returnStmtCollector.raisesExceptions() && !CheckUtils.isAbstract(funDef) && !classIsProtocolLike) {
            ctx.addIssue(funDef.defKeyword(), funDef.colon(), String.format(NO_RETURN_STMTS_MESSAGE, expectedReturnType));
            return;
        }
        for (ReturnStatement returnStmt : returnStmts) {
            SpecialMethodReturnTypeCheck.checkReturnStmt(ctx, funNameString, expectedReturnType, returnStmt);
        }
    }

    private static void checkReturnStmt(SubscriptionContext ctx, String methodName, String expectedReturnType, ReturnStatement returnStmt) {
        List returnedExpressions = returnStmt.expressions();
        if (returnedExpressions.isEmpty()) {
            ctx.addIssue(returnStmt.returnKeyword(), String.format(INVALID_RETURN_TYPE_MESSAGE_NO_LOCATION, expectedReturnType));
            return;
        }
        InferredType returnStmtType = returnStmt.returnValueType();
        if (!returnStmtType.canBeOrExtend(expectedReturnType)) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStmt, String.format(INVALID_RETURN_TYPE_MESSAGE, expectedReturnType));
            return;
        }
        if ("__getnewargs_ex__".equals(methodName)) {
            SpecialMethodReturnTypeCheck.isGetNewArgsExCompliant(ctx, returnStmt);
        }
    }

    private static void isGetNewArgsExCompliant(SubscriptionContext ctx, ReturnStatement returnStatement) {
        List returnedExpressions = returnStatement.expressions();
        int numReturnedExpressions = returnedExpressions.size();
        if (numReturnedExpressions == 1) {
            Expression firstExpression = (Expression)returnedExpressions.get(0);
            if (firstExpression instanceof TupleImpl) {
                TupleImpl tupleImpl = (TupleImpl)firstExpression;
                returnedExpressions = tupleImpl.elements();
                numReturnedExpressions = returnedExpressions.size();
            } else {
                return;
            }
        }
        if (numReturnedExpressions != 2) {
            ReturnCheckUtils.addIssueOnReturnedExpressions(ctx, returnStatement, String.format(INVALID_GETNEWARGSEX_ELEMENT_COUNT_MESSAGE, numReturnedExpressions));
            return;
        }
        Expression firstElement = (Expression)returnedExpressions.get(0);
        Expression secondElement = (Expression)returnedExpressions.get(1);
        if (!firstElement.type().canBeOrExtend("tuple") || !secondElement.type().canBeOrExtend("dict")) {
            ctx.addIssue(firstElement.firstToken(), secondElement.lastToken(), INVALID_GETNEWARGSEX_TUPLE_MESSAGE);
        }
    }
}

