/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.django;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.django.DjangoUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6559")
public class DjangoModelFormFieldsCheck
extends PythonSubscriptionCheck {
    public static final String ALL_MESSAGE = "Set the fields of this form explicitly instead of using \"__all__\".";
    public static final String EXCLUDE_MESSAGE = "Set the fields of this form explicitly instead of using \"exclude\".";
    private static final String DJANGO_MODEL_FORM_FQN = "django.forms.ModelForm";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            if (TreeUtils.getParentClassesFQN((ClassDef)classDef).contains(DJANGO_MODEL_FORM_FQN)) {
                DjangoUtils.getMetaClass(classDef).ifPresent(metaClass -> {
                    DjangoUtils.getFieldAssignment(metaClass, "exclude").ifPresent(exclude -> ctx.addIssue((Tree)exclude, EXCLUDE_MESSAGE));
                    DjangoUtils.getFieldAssignment(metaClass, "fields").filter(fields -> DjangoModelFormFieldsCheck.isAllAssignedValue(fields.assignedValue())).ifPresent(fields -> ctx.addIssue((Tree)fields, ALL_MESSAGE));
                });
            }
        });
    }

    private static boolean isAllAssignedValue(Expression assignedValue) {
        return Optional.of(assignedValue).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).filter("__all__"::equals).isPresent();
    }
}

