/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S6537")
public class OctalEscapeCheck
extends AbstractRegexCheck {
    public static final String MESSAGE = "Consider replacing this octal escape sequence with a Unicode or hexadecimal sequence instead.";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        new CharacterFinder().visit(regexParseResult);
    }

    private class CharacterFinder
    extends RegexBaseVisitor {
        private CharacterFinder() {
        }

        public void visitCharacter(CharacterTree tree) {
            if (tree.isEscapeSequence() && tree.getText().matches("\\\\{1,2}\\d+")) {
                OctalEscapeCheck.this.addIssue((RegexSyntaxElement)tree, OctalEscapeCheck.MESSAGE, null, Collections.emptyList());
            }
            super.visitCharacter(tree);
        }
    }
}

