/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1854")
public class DeadStoreUtils {
    private DeadStoreUtils() {
    }

    public static List<UnnecessaryAssignment> findUnnecessaryAssignments(CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, FunctionDef functionDef) {
        ArrayList<UnnecessaryAssignment> unnecessaryAssignments = new ArrayList<UnnecessaryAssignment>();
        HashSet willBeRead = new HashSet(blockLiveVariables.getOut());
        ListIterator elementsReverseIterator = block.elements().listIterator(block.elements().size());
        while (elementsReverseIterator.hasPrevious()) {
            Tree element = (Tree)elementsReverseIterator.previous();
            blockLiveVariables.getSymbolReadWrites(element).forEach((symbol, symbolReadWrite) -> {
                if (symbolReadWrite.isWrite() && !symbolReadWrite.isRead()) {
                    if (!element.is(new Tree.Kind[]{Tree.Kind.IMPORT_NAME}) && !willBeRead.contains(symbol) && functionDef.localVariables().contains(symbol)) {
                        unnecessaryAssignments.add(new UnnecessaryAssignment((Symbol)symbol, element));
                    }
                    willBeRead.remove(symbol);
                } else if (symbolReadWrite.isRead()) {
                    willBeRead.add(symbol);
                }
            });
        }
        return unnecessaryAssignments;
    }

    public static boolean isParameter(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.PARAMETER}) || TreeUtils.firstAncestorOfKind((Tree)element, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.PARAMETER}) != null;
    }

    public static boolean isUsedInSubFunction(Symbol symbol, FunctionDef functionDef) {
        return symbol.usages().stream().anyMatch(usage -> TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA}) != functionDef);
    }

    public static class UnnecessaryAssignment {
        public final Symbol symbol;
        public final Tree element;

        private UnnecessaryAssignment(Symbol symbol, Tree element) {
            this.symbol = symbol;
            this.element = element;
        }
    }
}

