/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5714")
public class BooleanExpressionInExceptCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE = "Rewrite this \"except\" expression as a tuple of exception classes.";
    public static final String QUICK_FIX_MESSAGE = "Replace with a tuple";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, BooleanExpressionInExceptCheck::checkExceptClause);
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_GROUP_CLAUSE, BooleanExpressionInExceptCheck::checkExceptClause);
    }

    private static void checkExceptClause(SubscriptionContext ctx) {
        ExceptClause except = (ExceptClause)ctx.syntaxNode();
        Optional.of(except).map(ExceptClause::exception).map(Expressions::removeParentheses).filter(exception -> exception.is(new Tree.Kind[]{Tree.Kind.OR, Tree.Kind.AND})).ifPresent(exception -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)exception, MESSAGE);
            BooleanExpressionInExceptCheck.addQuickFix(issue, exception);
        });
    }

    private static List<String> collectNames(Expression expression) {
        expression = Expressions.removeParentheses(expression);
        if (expression.is(new Tree.Kind[]{Tree.Kind.OR, Tree.Kind.AND})) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            List<String> leftExceptions = BooleanExpressionInExceptCheck.collectNames(binaryExpression.leftOperand());
            List<String> rightExceptions = BooleanExpressionInExceptCheck.collectNames(binaryExpression.rightOperand());
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(leftExceptions);
            result.addAll(rightExceptions);
            return result;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            Name name = (Name)expression;
            return List.of(name.name());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            String name = TreeUtils.tokens((Tree)expression).stream().map(Token::value).collect(Collectors.joining());
            return List.of(name);
        }
        throw new IllegalArgumentException("Unsupported kind of tree element: " + expression.getKind().name());
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Expression expression) {
        List<String> names;
        expression = Objects.requireNonNullElse((Expression)TreeUtils.firstAncestorOfKind((Tree)expression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.PARENTHESIZED}), expression);
        try {
            names = BooleanExpressionInExceptCheck.collectNames(expression);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        String text = names.stream().collect(Collectors.joining(", ", "(", ")"));
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)QUICK_FIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)expression, (String)text)}).build();
        issue.addQuickFix(quickFix);
    }
}

