/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4426")
public class StrongCryptographicKeysCheck
extends PythonSubscriptionCheck {
    private static final Pattern CRYPTOGRAPHY = Pattern.compile("cryptography.hazmat.primitives.asymmetric.(rsa|dsa|ec).generate_private_key");
    private static final Pattern CRYPTOGRAPHY_FORBIDDEN_CURVE = Pattern.compile("(SECP192R1|SECT163K1|SECT163R2)");
    private static final Pattern CRYPTO = Pattern.compile("Crypto.PublicKey.(RSA|DSA).generate");
    private static final Pattern CRYPTODOME = Pattern.compile("Cryptodome.PublicKey.(RSA|DSA).generate");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            List arguments = callExpression.arguments();
            String qualifiedName = StrongCryptographicKeysCheck.getQualifiedName(callExpression);
            if (CRYPTOGRAPHY.matcher(qualifiedName).matches()) {
                new CryptographyModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTO.matcher(qualifiedName).matches()) {
                new CryptoModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            } else if (CRYPTODOME.matcher(qualifiedName).matches()) {
                new CryptodomeModuleCheck().checkArguments((SubscriptionContext)ctx, arguments);
            }
        });
    }

    private static String getQualifiedName(CallExpression callExpression) {
        Symbol symbol = callExpression.calleeSymbol();
        return symbol != null && symbol.fullyQualifiedName() != null ? symbol.fullyQualifiedName() : "";
    }

    public static Optional<RegularArgument> argument(int argPosition, String keyword, List<Argument> arguments) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword((int)argPosition, (String)keyword, arguments));
    }

    private static class CryptographyModuleCheck
    extends CryptoAPICheck {
        private static final int CURVE_ARGUMENT_POSITION = 0;

        private CryptographyModuleCheck() {
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 1;
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 0;
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "key_size";
        }

        @Override
        protected String getExponentKeywordName() {
            return "public_exponent";
        }

        @Override
        void checkArguments(SubscriptionContext ctx, List<Argument> arguments) {
            super.checkArguments(ctx, arguments);
            StrongCryptographicKeysCheck.argument(0, "curve", arguments).filter(arg -> CryptographyModuleCheck.isNonCompliantCurve(arg.expression())).ifPresent(arg -> ctx.addIssue((Tree)arg, "Use a key length of at least 224 bits."));
        }

        private static boolean isNonCompliantCurve(Expression expression) {
            if (!expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
                return false;
            }
            QualifiedExpression qualifiedExpressionTree = (QualifiedExpression)expression;
            Expression expression2 = qualifiedExpressionTree.qualifier();
            if (expression2 instanceof HasSymbol) {
                HasSymbol hasSymbol = (HasSymbol)expression2;
                Symbol symbol = hasSymbol.symbol();
                if (symbol == null || !"cryptography.hazmat.primitives.asymmetric.ec".equals(symbol.fullyQualifiedName())) {
                    return false;
                }
                return CRYPTOGRAPHY_FORBIDDEN_CURVE.matcher(qualifiedExpressionTree.name().name()).matches();
            }
            return false;
        }
    }

    private static class CryptoModuleCheck
    extends CryptoAPICheck {
        private CryptoModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 3;
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }
    }

    private static class CryptodomeModuleCheck
    extends CryptoAPICheck {
        private CryptodomeModuleCheck() {
        }

        @Override
        protected int getExponentArgumentPosition() {
            return 2;
        }

        @Override
        protected String getExponentKeywordName() {
            return "e";
        }

        @Override
        protected String getKeySizeKeywordName() {
            return "bits";
        }

        @Override
        protected int getKeySizeArgumentPosition() {
            return 0;
        }
    }

    private static abstract class CryptoAPICheck {
        private CryptoAPICheck() {
        }

        abstract int getKeySizeArgumentPosition();

        abstract int getExponentArgumentPosition();

        abstract String getKeySizeKeywordName();

        abstract String getExponentKeywordName();

        private static boolean isLessThan2048(RegularArgument argument) {
            return CryptoAPICheck.isLessThan(argument.expression(), 2048);
        }

        private static boolean isLessThan65537(RegularArgument argument) {
            return CryptoAPICheck.isLessThan(argument.expression(), 65537);
        }

        private static boolean isLessThan(Expression expression, int number) {
            try {
                return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && ((NumericLiteral)expression).valueAsLong() < (long)number;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        void checkArguments(SubscriptionContext ctx, List<Argument> arguments) {
            StrongCryptographicKeysCheck.argument(this.getKeySizeArgumentPosition(), this.getKeySizeKeywordName(), arguments).filter(CryptoAPICheck::isLessThan2048).ifPresent(arg -> ctx.addIssue((Tree)arg, "Use a key length of at least 2048 bits."));
            StrongCryptographicKeysCheck.argument(this.getExponentArgumentPosition(), this.getExponentKeywordName(), arguments).filter(CryptoAPICheck::isLessThan65537).ifPresent(arg -> ctx.addIssue((Tree)arg, "Use a public key exponent of at least 65537."));
        }
    }
}

