/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.checks.utils.StringLiteralValuesCollector;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1172")
public class UnusedFunctionParameterCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove the unused function parameter \"%s\".";
    private static final Set<String> AWS_LAMBDA_PARAMETERS = Set.of("event", "context");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> UnusedFunctionParameterCheck.checkFunctionParameter(ctx, (FunctionDef)ctx.syntaxNode()));
    }

    private static void checkFunctionParameter(SubscriptionContext ctx, FunctionDef functionDef) {
        if (UnusedFunctionParameterCheck.isException(ctx, functionDef)) {
            return;
        }
        functionDef.localVariables().stream().filter(symbol -> !UnusedFunctionParameterCheck.isIgnoredSymbolName(symbol.name())).filter(UnusedFunctionParameterCheck::isUnused).filter(symbol -> !UnusedFunctionParameterCheck.isUsedInStringLiteralOrComment(symbol.name(), functionDef)).map(symbol -> (Parameter)((Usage)symbol.usages().get(0)).tree().parent()).forEach(param -> ctx.addIssue((Tree)param, String.format(MESSAGE, param.name().name())));
    }

    private static boolean isUnused(Symbol s) {
        return s.usages().size() == 1 && ((Usage)s.usages().get(0)).tree().parent().is(new Tree.Kind[]{Tree.Kind.PARAMETER});
    }

    private static boolean isUsedInStringLiteralOrComment(String symbolName, FunctionDef functionDef) {
        StringLiteralValuesCollector stringLiteralValuesCollector = new StringLiteralValuesCollector();
        stringLiteralValuesCollector.collect((Tree)functionDef);
        List<String> comments = UnusedFunctionParameterCheck.collectComments((Tree)functionDef);
        Pattern p = Pattern.compile("(^|\\s+|\"|'|@)" + symbolName + "($|\\s+|\"|')");
        return stringLiteralValuesCollector.anyMatches(str -> p.matcher((CharSequence)str).find()) || comments.stream().anyMatch(str -> p.matcher((CharSequence)str).find());
    }

    private static boolean isIgnoredSymbolName(String symbolName) {
        return "self".equals(symbolName) || symbolName.startsWith("_") || AWS_LAMBDA_PARAMETERS.contains(symbolName);
    }

    private static boolean isException(SubscriptionContext ctx, FunctionDef functionDef) {
        FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
        return CheckUtils.containsCallToLocalsFunction((Tree)functionDef) || SymbolUtils.canBeAnOverridingMethod((FunctionSymbol)functionSymbol) || UnusedFunctionParameterCheck.isInterfaceMethod(functionDef) || UnusedFunctionParameterCheck.isNotImplemented(functionDef) || !functionDef.decorators().isEmpty() || UnusedFunctionParameterCheck.isSpecialMethod(functionDef) || UnusedFunctionParameterCheck.hasNonCallUsages(functionSymbol) || UnusedFunctionParameterCheck.isTestFunction(ctx, functionDef) || UnusedFunctionParameterCheck.isAbstractClass(functionDef);
    }

    private static boolean isAbstractClass(FunctionDef functionDef) {
        FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
        if (functionSymbol == null) {
            return false;
        }
        Symbol owner = ((FunctionSymbolImpl)functionSymbol).owner();
        return owner != null && (((ClassSymbolImpl)owner).superClasses().stream().anyMatch(symbol -> "abc.ABC".equals(symbol.fullyQualifiedName())) || ((ClassSymbolImpl)owner).hasMetaClass());
    }

    private static boolean isInterfaceMethod(FunctionDef functionDef) {
        return functionDef.body().statements().stream().allMatch(statement -> statement.is(new Tree.Kind[]{Tree.Kind.PASS_STMT, Tree.Kind.RAISE_STMT}) || statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT}) && UnusedFunctionParameterCheck.isStringExpressionOrEllipsis((ExpressionStatement)statement));
    }

    private static boolean isNotImplemented(FunctionDef functionDef) {
        List statements = functionDef.body().statements();
        if (statements.size() != 1) {
            return false;
        }
        if (!((Statement)statements.get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STMT})) {
            return false;
        }
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        return returnStatement.expressions().stream().allMatch(retValue -> TreeUtils.getSymbolFromTree((Tree)retValue).filter(s -> "NotImplemented".equals(s.fullyQualifiedName())).isPresent());
    }

    private static boolean isStringExpressionOrEllipsis(ExpressionStatement stmt) {
        return stmt.expressions().stream().allMatch(expr -> expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.ELLIPSIS}));
    }

    private static boolean isSpecialMethod(FunctionDef functionDef) {
        String name = functionDef.name().name();
        return name.startsWith("__") && name.endsWith("__");
    }

    private static boolean hasNonCallUsages(@Nullable FunctionSymbol functionSymbol) {
        return Optional.ofNullable(functionSymbol).filter(fs -> fs.usages().stream().anyMatch(usage -> usage.kind() != Usage.Kind.FUNC_DECLARATION && !UnusedFunctionParameterCheck.isFunctionCall(usage))).isPresent();
    }

    private static boolean isTestFunction(SubscriptionContext ctx, FunctionDef functionDef) {
        String fileName = ctx.pythonFile().fileName();
        if (fileName.startsWith("conftest") || fileName.startsWith("test")) {
            return true;
        }
        return functionDef.name().name().startsWith("test");
    }

    private static boolean isFunctionCall(Usage usage) {
        if (usage.kind() != Usage.Kind.OTHER) {
            return false;
        }
        Tree tree = usage.tree();
        CallExpression callExpression = (CallExpression)TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR});
        if (callExpression == null) {
            return false;
        }
        Expression callee = callExpression.callee();
        return callee == tree || TreeUtils.hasDescendant((Tree)callee, t -> t == tree);
    }

    private static List<String> collectComments(Tree element) {
        ArrayList<String> comments = new ArrayList<String>();
        ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
        stack.push(element);
        while (!stack.isEmpty()) {
            Tree currentElement = (Tree)stack.pop();
            if (currentElement.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
                ((Token)currentElement).trivia().stream().map(Trivia::value).forEach(comments::add);
            }
            for (int i = currentElement.children().size() - 1; i >= 0; --i) {
                Optional.ofNullable((Tree)currentElement.children().get(i)).ifPresent(stack::push);
            }
        }
        return comments;
    }
}

