/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6556")
public class DjangoRenderContextCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use an explicit context instead of passing \"locals()\" to this Django \"render\" call.";
    private static final String SECONDARY_MESSAGE = "locals() is assigned to \"%s\" here.";
    private static final String RENDER_FUNCTION = "django.shortcuts.render";
    private static final String LOCALS = "locals";
    private static final String CONTEXT_KEYWORD = "context";
    private static final int MAX_RECURSION_COUNT = 5;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, DjangoRenderContextCheck::checkForDjangoRender);
    }

    private static void checkForDjangoRender(SubscriptionContext ctx) {
        CallExpression expression = (CallExpression)ctx.syntaxNode();
        Symbol symbol = expression.calleeSymbol();
        if (symbol != null && RENDER_FUNCTION.equals(symbol.fullyQualifiedName())) {
            DjangoRenderContextCheck.checkForContextArgument(ctx, expression);
        }
    }

    private static void checkForContextArgument(SubscriptionContext ctx, CallExpression expression) {
        RegularArgument contextArg = TreeUtils.nthArgumentOrKeyword((int)2, (String)CONTEXT_KEYWORD, (List)expression.arguments());
        if (contextArg != null) {
            if (contextArg.expression().is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
                CallExpression maybeLocalsCall = (CallExpression)contextArg.expression();
                if (DjangoRenderContextCheck.isLocalsCall(maybeLocalsCall)) {
                    ctx.addIssue((Tree)maybeLocalsCall, MESSAGE);
                }
            } else if (contextArg.expression().is(new Tree.Kind[]{Tree.Kind.NAME})) {
                DjangoRenderContextCheck.checkIfLocalsIsAssignedToContextParameter(ctx, contextArg, (Name)contextArg.expression(), 0);
            }
        }
    }

    private static void checkIfLocalsIsAssignedToContextParameter(SubscriptionContext ctx, RegularArgument contextArg, Name maybeLocalsCall, int recursionCount) {
        Tree assignment;
        Expression assignedValue;
        List<Tree> assignmentStmts;
        Symbol contextSymbol;
        if (recursionCount <= 5 && (contextSymbol = maybeLocalsCall.symbol()) != null && (assignmentStmts = contextSymbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.ASSIGNMENT_LHS).map(Usage::tree).map(usage -> TreeUtils.firstAncestorOfKind((Tree)usage, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_EXPRESSION, Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT})).filter(Objects::nonNull).toList()).size() == 1 && (assignedValue = DjangoRenderContextCheck.getAssignedValue(assignment = assignmentStmts.get(0))) != null) {
            DjangoRenderContextCheck.checkIfLocalsIsCalledOrFindTheNextAncestor(ctx, contextArg, assignment, assignedValue, recursionCount);
        }
    }

    @CheckForNull
    private static Expression getAssignedValue(Tree assignment) {
        if (assignment.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
            return ((AssignmentStatement)assignment).assignedValue();
        }
        if (assignment.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT})) {
            return ((AnnotatedAssignment)assignment).assignedValue();
        }
        return ((AssignmentExpression)assignment).expression();
    }

    private static void checkIfLocalsIsCalledOrFindTheNextAncestor(SubscriptionContext ctx, RegularArgument contextArg, Tree assignment, Expression assignedValue, int recursionCount) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            CallExpression localsAssignment = (CallExpression)assignedValue;
            if (DjangoRenderContextCheck.isLocalsCall(localsAssignment)) {
                DjangoRenderContextCheck.raiseIssueLocalsIsAssigned(ctx, contextArg, assignment, localsAssignment);
            }
        } else if (assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            DjangoRenderContextCheck.checkIfLocalsIsAssignedToContextParameter(ctx, contextArg, (Name)assignedValue, recursionCount + 1);
        }
    }

    private static void raiseIssueLocalsIsAssigned(SubscriptionContext ctx, RegularArgument contextArg, Tree assignment, CallExpression localsAssignment) {
        PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)contextArg.expression(), MESSAGE);
        if (assignment.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
            ((AssignmentStatement)assignment).lhsExpressions().stream().flatMap(e -> e.expressions().stream()).filter(expression -> expression.is(new Tree.Kind[]{Tree.Kind.NAME})).map(Name.class::cast).forEach(namedVariable -> preciseIssue.secondary((Tree)localsAssignment, String.format(SECONDARY_MESSAGE, namedVariable.name())));
        } else if (assignment.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT})) {
            Expression variable = ((AnnotatedAssignment)assignment).variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.NAME})) {
                preciseIssue.secondary((Tree)localsAssignment, String.format(SECONDARY_MESSAGE, ((Name)variable).name()));
            }
        } else {
            Name variable = ((AssignmentExpression)assignment).lhsName();
            preciseIssue.secondary((Tree)localsAssignment, String.format(SECONDARY_MESSAGE, variable.name()));
        }
    }

    private static boolean isLocalsCall(CallExpression callExpression) {
        Symbol localsSymbol = callExpression.calleeSymbol();
        return localsSymbol != null && LOCALS.equals(localsSymbol.fullyQualifiedName());
    }
}

