/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

public class UnrestrictedAdministrationCheckPartConnections
extends AbstractCdkResourceCheck {
    private static final String MESSAGE_BAD_PEER = "Change this IP range to a subset of trusted IP addresses.";
    private static final String MESSAGE_BAD_METHOD = "Change this method for `allow_from` and set `other` to a subset of trusted IP addresses.";
    private static final String OTHER = "other";
    private static final String PORT_RANGE = "port_range";
    private static final Set<Long> ADMIN_PORTS = Set.of(Long.valueOf(22L), Long.valueOf(3389L));
    private static final Predicate<Expression> IS_SENSITIVE_PROTOCOL = CdkPredicate.isFqn("aws_cdk.aws_ec2.Protocol.ALL").or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Protocol.TCP"));
    private static final Predicate<Expression> IS_SENSITIVE_PORT = CdkPredicate.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_ec2.Port.all_tcp").or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Port.all_traffic")).or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Port.tcp").and(CdkPredicate.hasArgument("port", 0, CdkPredicate.isNumeric(ADMIN_PORTS)))).or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Port.tcp_range").and(CdkPredicate.hasIntervalArguments("start_port", 0, "end_port", 1, ADMIN_PORTS))).or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Port").and(CdkPredicate.hasArgument("protocol", IS_SENSITIVE_PROTOCOL)).and(CdkPredicate.hasIntervalArguments("from_port", "to_port", ADMIN_PORTS))));
    private static final Predicate<Expression> IS_SENSITIVE_PEER = CdkPredicate.isFqn("aws_cdk.aws_ec2.Peer.any_ipv4").or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Peer.any_ipv6")).or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Peer.ipv4").and(CdkPredicate.hasArgument("cidr_ip", 0, CdkPredicate.isString("0.0.0.0/0")))).or(CdkPredicate.isFqn("aws_cdk.aws_ec2.Peer.ipv6").and(CdkPredicate.hasArgument("cidr_ip", 0, CdkPredicate.isString("::/0"))));

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_ec2.Connections.allow_from", UnrestrictedAdministrationCheckPartConnections.checkPeerAndPortSensitivity(OTHER, PORT_RANGE));
        this.checkFqn("aws_cdk.aws_ec2.Connections.allow_from_any_ipv4", UnrestrictedAdministrationCheckPartConnections.checkPortSensitivity(PORT_RANGE));
        this.checkFqn("aws_cdk.aws_ec2.Connections.allow_default_port_from", UnrestrictedAdministrationCheckPartConnections::checkPeerAndDefaultPortInConstructorCall);
        this.checkFqn("aws_cdk.aws_ec2.Connections.allow_default_port_from_any_ipv4", UnrestrictedAdministrationCheckPartConnections::checkDefaultPortInConstructorCall);
        this.checkFqn("aws_cdk.aws_ec2.SecurityGroup.add_ingress_rule", UnrestrictedAdministrationCheckPartConnections.checkPeerAndPortSensitivity("peer", "connection"));
    }

    private static void checkPeerAndDefaultPortInConstructorCall(SubscriptionContext ctx, CallExpression callExpression) {
        CdkUtils.getArgument(ctx, callExpression, OTHER, 0).filter(flow -> flow.hasExpression(IS_SENSITIVE_PEER)).ifPresent(flow -> UnrestrictedAdministrationCheckPartConnections.checkDefaultPortInConstructorCall(ctx, callExpression));
    }

    private static void checkDefaultPortInConstructorCall(SubscriptionContext ctx, CallExpression callExpression) {
        Expression expression = callExpression.callee();
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            expression = ((QualifiedExpression)expression).qualifier();
        }
        CdkUtils.ExpressionFlow flowObj = CdkUtils.ExpressionFlow.build(ctx, expression);
        flowObj.getExpression(CdkPredicate.isCallExpression().and(CdkPredicate.isFqn("aws_cdk.aws_ec2.Connections"))).map(CallExpression.class::cast).flatMap(callExpr -> CdkUtils.getArgument(ctx, callExpr, "default_port")).filter(flow -> flow.hasExpression(IS_SENSITIVE_PORT)).ifPresent(flow -> ctx.addIssue((Tree)UnrestrictedAdministrationCheckPartConnections.getMethodPrimaryLocation(callExpression), MESSAGE_BAD_METHOD));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkPeerAndPortSensitivity(String peerName, String portName) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, peerName, 0).filter(flow -> flow.hasExpression(IS_SENSITIVE_PEER)).flatMap(flow -> CdkUtils.getArgument(ctx, callExpression, portName, 1)).filter(flow -> flow.hasExpression(IS_SENSITIVE_PORT)).flatMap(flow -> CdkUtils.getArgument(ctx, callExpression, peerName, 0)).ifPresent(flow -> flow.addIssue(MESSAGE_BAD_PEER, new IssueLocation[0]));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkPortSensitivity(String portName) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, portName, 0).filter(flow -> flow.hasExpression(IS_SENSITIVE_PORT)).ifPresent(flow -> ctx.addIssue((Tree)UnrestrictedAdministrationCheckPartConnections.getMethodPrimaryLocation(callExpression), MESSAGE_BAD_METHOD));
    }

    private static Expression getMethodPrimaryLocation(CallExpression callExpression) {
        Expression expression = callExpression.callee();
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            return ((QualifiedExpression)expression).name();
        }
        return expression;
    }
}

