/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.CfgUtils;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.checks.utils.DeadStoreUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1226")
public class IgnoredParameterCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TEMPLATE = "Introduce a new variable or use its initial value before reassigning '%s'.";
    private static final String SECONDARY_MESSAGE_TEMPLATE = "'%s' is reassigned here.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            LiveVariablesAnalysis lva = LiveVariablesAnalysis.analyze((ControlFlowGraph)cfg);
            Set unreachableBlocks = CfgUtils.unreachableBlocks((ControlFlowGraph)cfg);
            cfg.blocks().forEach(block -> {
                List<DeadStoreUtils.UnnecessaryAssignment> unnecessaryAssignments = DeadStoreUtils.findUnnecessaryAssignments(block, lva.getLiveVariables(block), functionDef);
                unnecessaryAssignments.stream().filter(assignment -> !assignment.symbol.name().equals("_")).filter(assignment -> DeadStoreUtils.isParameter(assignment.element)).filter(assignment -> assignment.symbol.usages().stream().filter(Usage::isBindingUsage).count() > 1L).filter(assignment -> !IgnoredParameterCheck.isSymbolUsedInUnreachableBlocks(lva, unreachableBlocks, assignment.symbol)).filter(assignment -> !DeadStoreUtils.isUsedInSubFunction(assignment.symbol, functionDef)).forEach(assignment -> {
                    PythonCheck.PreciseIssue issue = ctx.addIssue(assignment.element, String.format(MESSAGE_TEMPLATE, assignment.symbol.name()));
                    ((Map)assignment.symbol.usages().stream().filter(Usage::isBindingUsage).filter(u -> u.kind() != Usage.Kind.PARAMETER).map(Usage::tree).collect(TreeUtils.groupAssignmentByParentStatementList())).values().stream().sorted(TreeUtils.getTreeByPositionComparator()).map(IgnoredParameterCheck::mapToParentAssignmentStatementOrExpression).forEach(tree -> issue.secondary(tree, String.format(SECONDARY_MESSAGE_TEMPLATE, assignment.symbol.name())));
                });
            });
        });
    }

    private static Tree mapToParentAssignmentStatementOrExpression(Tree tree) {
        Tree assignment = TreeUtils.firstAncestor((Tree)tree, parent -> parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ASSIGNMENT_EXPRESSION}));
        if (assignment != null) {
            return assignment;
        }
        return tree;
    }

    private static boolean isSymbolUsedInUnreachableBlocks(LiveVariablesAnalysis lva, Set<CfgBlock> unreachableBlocks, Symbol symbol) {
        return unreachableBlocks.stream().anyMatch(b -> lva.getLiveVariables(b).isSymbolUsedInBlock(symbol));
    }
}

