/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.types.v2.PythonType;
import org.sonar.python.types.v2.TriBool;

@Rule(key="S112")
public class GenericExceptionRaisedCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raise = (RaiseStatement)ctx.syntaxNode();
            List expressions = raise.expressions();
            if (expressions.isEmpty()) {
                return;
            }
            Expression expression = (Expression)expressions.get(0);
            PythonType pythonType = expression.typeV2();
            TriBool isException = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("Exception").check(pythonType);
            TriBool isBaseException = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("BaseException").check(pythonType);
            if (isException == TriBool.TRUE || isBaseException == TriBool.TRUE) {
                ctx.addIssue((Tree)expression, "Replace this generic exception class with a more specific one.");
            }
        });
    }
}

