/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6735")
public class PandasAddMergeParametersCheck
extends PythonSubscriptionCheck {
    private static final String DATAFRAME_JOIN_FQN = "pandas.core.frame.DataFrame.join";
    private static final String DATAFRAME_MERGE_FQN = "pandas.core.frame.DataFrame.merge";
    private static final String PANDAS_MERGE_FQN = "pandas.core.reshape.merge.merge";
    private static final Set<Keywords> ON_KEYWORDS = EnumSet.of(Keywords.ON, Keywords.LEFT_ON, Keywords.RIGHT_ON);
    private static final Set<String> METHODS = Set.of("pandas.core.frame.DataFrame.join", "pandas.core.frame.DataFrame.merge", "pandas.core.reshape.merge.merge");
    private static final Map<Integer, String> MESSAGES = Map.of(1, "Specify the \"%s\" parameter of this %s.", 2, "Specify the \"%s\" and \"%s\" parameters of this %s.", 3, "Specify the \"%s\", \"%s\" and \"%s\" parameters of this %s.");
    private static final String QUICKFIX_MESSAGE = "Add the missing parameters";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, PandasAddMergeParametersCheck::verifyMergeCallParameters);
    }

    private static void verifyMergeCallParameters(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(METHODS::contains).ifPresent(fqn -> PandasAddMergeParametersCheck.missingArguments(fqn, ctx, callExpression));
    }

    private static void missingArguments(String fullyQualifiedName, SubscriptionContext ctx, CallExpression callExpression) {
        ArrayList<Keywords> missingKeywords = new ArrayList<Keywords>();
        if (PandasAddMergeParametersCheck.isArgumentMissing(fullyQualifiedName, Keywords.HOW, callExpression.arguments())) {
            missingKeywords.add(Keywords.HOW);
        }
        if (ON_KEYWORDS.stream().allMatch(keyword -> PandasAddMergeParametersCheck.isArgumentMissing(fullyQualifiedName, keyword, callExpression.arguments()))) {
            missingKeywords.add(Keywords.ON);
        }
        if (PandasAddMergeParametersCheck.isArgumentMissing(fullyQualifiedName, Keywords.VALIDATE, callExpression.arguments())) {
            missingKeywords.add(Keywords.VALIDATE);
        }
        if (!missingKeywords.isEmpty()) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callExpression, PandasAddMergeParametersCheck.generateMessage(MESSAGES.get(PandasAddMergeParametersCheck.numberOfMissingArguments(missingKeywords)), missingKeywords, fullyQualifiedName));
            issue.addQuickFix(PythonQuickFix.newQuickFix((String)QUICKFIX_MESSAGE).addTextEdit(new PythonTextEdit[]{TextEditUtils.insertBefore((Tree)callExpression.rightPar(), (String)PandasAddMergeParametersCheck.getReplacementText(fullyQualifiedName, missingKeywords))}).build());
        }
    }

    private static boolean isArgumentMissing(String fullyQualfiedName, Keywords keyword, List<Argument> arguments) {
        return Optional.of(keyword).map(kw -> TreeUtils.nthArgumentOrKeyword((int)kw.getArgumentPosition(fullyQualfiedName), (String)kw.getKeyword(), (List)arguments)).isEmpty();
    }

    private static String generateMessage(String message, List<Keywords> missingKeywords, String functionName) {
        List missingKeywordsList = missingKeywords.stream().map(Keywords::getKeyword).collect(Collectors.toList());
        missingKeywordsList.add(functionName.substring(functionName.lastIndexOf(46) + 1));
        return String.format(message, missingKeywordsList.toArray());
    }

    private static int numberOfMissingArguments(List<Keywords> missingKeywords) {
        return missingKeywords.size();
    }

    private static String getReplacementText(String fullyQualifiedName, List<Keywords> missingKeywords) {
        return String.format(", %s", missingKeywords.stream().map(keyword -> keyword.getReplacementText(fullyQualifiedName)).collect(Collectors.joining(", ")));
    }

    static enum Keywords {
        HOW("how", 2, 1, 2, "\"inner\"", "\"left\""),
        ON("on", 1, 2, 3, "None", "None"),
        VALIDATE("validate", 6, 11, 12, "\"many_to_many\"", "\"many_to_many\""),
        LEFT_ON("left_on", -1, 3, 4, "None", "None"),
        RIGHT_ON("right_on", -1, 4, 5, "None", "None");

        final String keyword;
        final int positionInJoin;
        final int positionInDataFrameMerge;
        final int positionInPandasMerge;
        final String defaultValueMerge;
        final String defaultValueJoin;

        public String getKeyword() {
            return this.keyword;
        }

        public int getPositionInJoin() {
            return this.positionInJoin;
        }

        public int getPositionInDataFrameMerge() {
            return this.positionInDataFrameMerge;
        }

        public int getPositionInPandasMerge() {
            return this.positionInPandasMerge;
        }

        String getReplacementText(String fullyQualifiedName) {
            if (PandasAddMergeParametersCheck.DATAFRAME_JOIN_FQN.equals(fullyQualifiedName)) {
                return String.format("%s=%s", this.keyword, this.defaultValueJoin);
            }
            return String.format("%s=%s", this.keyword, this.defaultValueMerge);
        }

        int getArgumentPosition(String fullyQualifiedName) {
            if (PandasAddMergeParametersCheck.DATAFRAME_JOIN_FQN.equals(fullyQualifiedName)) {
                return this.getPositionInJoin();
            }
            if (PandasAddMergeParametersCheck.DATAFRAME_MERGE_FQN.equals(fullyQualifiedName)) {
                return this.getPositionInDataFrameMerge();
            }
            return this.getPositionInPandasMerge();
        }

        private Keywords(String keyword, int positionInJoin, int positionInDataFrameMerge, int positionInPandasMerge, String defaultValueMerge, String defaultValueJoin) {
            this.keyword = keyword;
            this.positionInJoin = positionInJoin;
            this.positionInDataFrameMerge = positionInDataFrameMerge;
            this.positionInPandasMerge = positionInPandasMerge;
            this.defaultValueMerge = defaultValueMerge;
            this.defaultValueJoin = defaultValueJoin;
        }
    }
}

